/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { css } from 'lit';
export default css([
  '.cds--layout--size-xs{--cds-layout-size-height-context:var(--cds-layout-size-height-xs, 1.5rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-xs{--cds-layout-size-height:var(--cds-layout-size-height-context, var(--cds-layout-size-height-xs, 1.5rem))}.cds--layout-constraint--size__min-xs{--cds-layout-size-height-min:var(--cds-layout-size-height-xs, 1.5rem)}.cds--layout-constraint--size__max-xs{--cds-layout-size-height-max:var(--cds-layout-size-height-xs, 1.5rem)}.cds--layout--size-sm,:host(cds-content-switcher[size=sm]){--cds-layout-size-height-context:var(--cds-layout-size-height-sm, 2rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-sm{--cds-layout-size-height:var(--cds-layout-size-height-context, var(--cds-layout-size-height-sm, 2rem))}.cds--layout-constraint--size__min-sm{--cds-layout-size-height-min:var(--cds-layout-size-height-sm, 2rem)}.cds--layout-constraint--size__max-sm{--cds-layout-size-height-max:var(--cds-layout-size-height-sm, 2rem)}.cds--layout--size-md{--cds-layout-size-height-context:var(--cds-layout-size-height-md, 2.5rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-md{--cds-layout-size-height:var(--cds-layout-size-height-context, var(--cds-layout-size-height-md, 2.5rem))}.cds--layout-constraint--size__min-md{--cds-layout-size-height-min:var(--cds-layout-size-height-md, 2.5rem)}.cds--layout-constraint--size__max-md{--cds-layout-size-height-max:var(--cds-layout-size-height-md, 2.5rem)}.cds--layout--size-lg,:host(cds-content-switcher[size=lg]){--cds-layout-size-height-context:var(--cds-layout-size-height-lg, 3rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-lg{--cds-layout-size-height:var(--cds-layout-size-height-context, var(--cds-layout-size-height-lg, 3rem))}.cds--layout-constraint--size__min-lg{--cds-layout-size-height-min:var(--cds-layout-size-height-lg, 3rem)}.cds--layout-constraint--size__max-lg{--cds-layout-size-height-max:var(--cds-layout-size-height-lg, 3rem)}.cds--layout--size-xl{--cds-layout-size-height-context:var(--cds-layout-size-height-xl, 4rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-xl{--cds-layout-size-height:var(--cds-layout-size-height-context, var(--cds-layout-size-height-xl, 4rem))}.cds--layout-constraint--size__min-xl{--cds-layout-size-height-min:var(--cds-layout-size-height-xl, 4rem)}.cds--layout-constraint--size__max-xl{--cds-layout-size-height-max:var(--cds-layout-size-height-xl, 4rem)}.cds--layout--size-2xl{--cds-layout-size-height-context:var(--cds-layout-size-height-2xl, 5rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-2xl{--cds-layout-size-height:var(--cds-layout-size-height-context, var(--cds-layout-size-height-2xl, 5rem))}.cds--layout-constraint--size__min-2xl{--cds-layout-size-height-min:var(--cds-layout-size-height-2xl, 5rem)}.cds--layout-constraint--size__max-2xl{--cds-layout-size-height-max:var(--cds-layout-size-height-2xl, 5rem)}.cds--layout--density-condensed{--cds-layout-density-padding-inline-context:var(--cds-layout-density-padding-inline-condensed, 0.5rem);--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context)}.cds--layout-constraint--density__default-condensed{--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context, var(--cds-layout-density-padding-inline-condensed, 0.5rem))}.cds--layout-constraint--density__min-condensed{--cds-layout-density-padding-inline-min:var(--cds-layout-density-padding-inline-condensed, 0.5rem)}.cds--layout-constraint--density__max-condensed{--cds-layout-density-padding-inline-max:var(--cds-layout-density-padding-inline-condensed, 0.5rem)}.cds--layout--density-normal{--cds-layout-density-padding-inline-context:var(--cds-layout-density-padding-inline-normal, 1rem);--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context)}.cds--layout-constraint--density__default-normal{--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context, var(--cds-layout-density-padding-inline-normal, 1rem))}.cds--layout-constraint--density__min-normal{--cds-layout-density-padding-inline-min:var(--cds-layout-density-padding-inline-normal, 1rem)}.cds--layout-constraint--density__max-normal{--cds-layout-density-padding-inline-max:var(--cds-layout-density-padding-inline-normal, 1rem)}:root{--cds-layout-size-height-xs:1.5rem;--cds-layout-size-height-sm:2rem;--cds-layout-size-height-md:2.5rem;--cds-layout-size-height-lg:3rem;--cds-layout-size-height-xl:4rem;--cds-layout-size-height-2xl:5rem;--cds-layout-size-height-min:0px;--cds-layout-size-height-max:999999999px;--cds-layout-density-padding-inline-condensed:0.5rem;--cds-layout-density-padding-inline-normal:1rem;--cds-layout-density-padding-inline-min:0px;--cds-layout-density-padding-inline-max:999999999px}:root{--cds-layer:var(--cds-layer-01, #f4f4f4);--cds-layer-active:var(--cds-layer-active-01, #c6c6c6);--cds-layer-hover:var(--cds-layer-hover-01, #e8e8e8);--cds-layer-selected:var(--cds-layer-selected-01, #e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-01, #d1d1d1);--cds-layer-accent:var(--cds-layer-accent-01, #e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-01, #d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-01, #a8a8a8);--cds-field:var(--cds-field-01, #f4f4f4);--cds-field-hover:var(--cds-field-hover-01, #e8e8e8);--cds-border-subtle:var(--cds-border-subtle-00, #e0e0e0);--cds-border-subtle-selected:var(--cds-border-subtle-selected-01, #c6c6c6);--cds-border-strong:var(--cds-border-strong-01, #8d8d8d);--cds-border-tile:var(--cds-border-tile-01, #c6c6c6)}.cds--layer-one{--cds-layer:var(--cds-layer-01, #f4f4f4);--cds-layer-active:var(--cds-layer-active-01, #c6c6c6);--cds-layer-hover:var(--cds-layer-hover-01, #e8e8e8);--cds-layer-selected:var(--cds-layer-selected-01, #e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-01, #d1d1d1);--cds-layer-accent:var(--cds-layer-accent-01, #e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-01, #d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-01, #a8a8a8);--cds-field:var(--cds-field-01, #f4f4f4);--cds-field-hover:var(--cds-field-hover-01, #e8e8e8);--cds-border-subtle:var(--cds-border-subtle-00, #e0e0e0);--cds-border-subtle-selected:var(--cds-border-subtle-selected-01, #c6c6c6);--cds-border-strong:var(--cds-border-strong-01, #8d8d8d);--cds-border-tile:var(--cds-border-tile-01, #c6c6c6)}.cds--layer-two{--cds-layer:var(--cds-layer-02, #ffffff);--cds-layer-active:var(--cds-layer-active-02, #c6c6c6);--cds-layer-hover:var(--cds-layer-hover-02, #e8e8e8);--cds-layer-selected:var(--cds-layer-selected-02, #e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-02, #d1d1d1);--cds-layer-accent:var(--cds-layer-accent-02, #e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-02, #d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-02, #a8a8a8);--cds-field:var(--cds-field-02, #ffffff);--cds-field-hover:var(--cds-field-hover-02, #e8e8e8);--cds-border-subtle:var(--cds-border-subtle-01, #c6c6c6);--cds-border-subtle-selected:var(--cds-border-subtle-selected-02, #c6c6c6);--cds-border-strong:var(--cds-border-strong-02, #8d8d8d);--cds-border-tile:var(--cds-border-tile-02, #a8a8a8)}.cds--layer-three{--cds-layer:var(--cds-layer-03, #f4f4f4);--cds-layer-active:var(--cds-layer-active-03, #c6c6c6);--cds-layer-hover:var(--cds-layer-hover-03, #e8e8e8);--cds-layer-selected:var(--cds-layer-selected-03, #e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-03, #d1d1d1);--cds-layer-accent:var(--cds-layer-accent-03, #e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-03, #d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-03, #a8a8a8);--cds-field:var(--cds-field-03, #f4f4f4);--cds-field-hover:var(--cds-field-hover-03, #e8e8e8);--cds-border-subtle:var(--cds-border-subtle-02, #e0e0e0);--cds-border-subtle-selected:var(--cds-border-subtle-selected-03, #c6c6c6);--cds-border-strong:var(--cds-border-strong-03, #8d8d8d);--cds-border-tile:var(--cds-border-tile-03, #c6c6c6)}@keyframes hide-feedback{0%{opacity:1;visibility:inherit}100%{opacity:0;visibility:hidden}}@keyframes show-feedback{0%{opacity:0;visibility:hidden}100%{opacity:1;visibility:inherit}}@keyframes skeleton{0%{opacity:.3;transform:scaleX(0);transform-origin:left}20%{opacity:1;transform:scaleX(1);transform-origin:left}28%{transform:scaleX(1);transform-origin:right}51%{transform:scaleX(0);transform-origin:right}58%{transform:scaleX(0);transform-origin:right}82%{transform:scaleX(1);transform-origin:right}83%{transform:scaleX(1);transform-origin:left}96%{transform:scaleX(0);transform-origin:left}100%{opacity:.3;transform:scaleX(0);transform-origin:left}}.cds--assistive-text,.cds--visually-hidden{position:absolute;overflow:hidden;width:1px;height:1px;padding:0;border:0;margin:-1px;clip:rect(0,0,0,0);visibility:inherit;white-space:nowrap}.cds--popover-container{position:relative;display:inline-block}.cds--popover--high-contrast .cds--popover{--cds-popover-background-color:var(--cds-background-inverse, #393939);--cds-popover-text-color:var(--cds-text-inverse, #ffffff)}.cds--popover--drop-shadow .cds--popover{--cds-popover-drop-shadow:drop-shadow(0 2px 2px rgba(0, 0, 0, 0.2))}.cds--popover--caret{--cds-popover-offset:0.625rem}.cds--popover{position:absolute;z-index:6000;filter:var(--cds-popover-drop-shadow, none);inset:0;pointer-events:none}.cds--popover-content{box-sizing:border-box;padding:0;border:0;margin:0;font-family:inherit;font-size:100%;vertical-align:baseline;position:absolute;z-index:6000;display:none;width:-moz-max-content;width:max-content;max-width:23rem;background-color:var(--cds-popover-background-color,var(--cds-layer));border-radius:var(--cds-popover-border-radius,2px);color:var(--cds-popover-text-color,var(--cds-text-primary,#161616));pointer-events:auto}.cds--popover-content *,.cds--popover-content ::after,.cds--popover-content ::before{box-sizing:inherit}.cds--popover--open>.cds--popover>.cds--popover-content{display:block}.cds--popover-content::before{position:absolute;display:none;content:""}.cds--popover--open>.cds--popover>.cds--popover-content::before{display:block}.cds--popover-caret{position:absolute;z-index:6000;display:none;background-color:var(--cds-popover-background-color,var(--cds-layer));will-change:transform}.cds--popover--open>.cds--popover>.cds--popover-caret{display:block}.cds--popover--tab-tip>.cds--popover .cds--popover-caret{display:none}.cds--popover--bottom>.cds--popover .cds--popover-content{bottom:0;left:50%;transform:translate(-50%,calc(100% + var(--cds-popover-offset,0)))}.cds--popover--bottom-left>.cds--popover .cds--popover-content{bottom:0;left:0;transform:translate(calc(-1 * var(--cds-popover-offset,0)),calc(100% + var(--cds-popover-offset,0)))}.cds--popover--bottom-right>.cds--popover .cds--popover-content{right:0;bottom:0;transform:translate(var(--cds-popover-offset,0),calc(100% + var(--cds-popover-offset,0)))}.cds--popover--bottom-left>.cds--popover .cds--popover-content::before,.cds--popover--bottom-right>.cds--popover .cds--popover-content::before,.cds--popover--bottom>.cds--popover .cds--popover-content::before{top:0;right:0;left:0;height:var(--cds-popover-offset,0);transform:translateY(-100%)}.cds--popover--bottom-left>.cds--popover .cds--popover-caret,.cds--popover--bottom-right>.cds--popover .cds--popover-caret,.cds--popover--bottom>.cds--popover .cds--popover-caret{bottom:0;left:50%;width:var(--cds-popover-caret-width,.75rem);height:var(--cds-popover-caret-height,.375rem);-webkit-clip-path:polygon(0 100%,50% 0,100% 100%);clip-path:polygon(0 100%,50% 0,100% 100%);transform:translate(-50%,var(--cds-popover-offset,0))}.cds--popover--top>.cds--popover .cds--popover-content{top:0;left:50%;transform:translate(-50%,calc(-100% - var(--cds-popover-offset,0)))}.cds--popover--top-left>.cds--popover .cds--popover-content{top:0;left:0;transform:translate(calc(-1 * var(--cds-popover-offset,0)),calc(-100% - var(--cds-popover-offset,0)))}.cds--popover--top-right>.cds--popover .cds--popover-content{top:0;right:0;transform:translate(var(--cds-popover-offset,0),calc(-100% - var(--cds-popover-offset,0)))}.cds--popover--top-left>.cds--popover .cds--popover-content::before,.cds--popover--top-right>.cds--popover .cds--popover-content::before,.cds--popover--top>.cds--popover .cds--popover-content::before{right:0;bottom:0;left:0;height:var(--cds-popover-offset,0);transform:translateY(100%)}.cds--popover--top-left>.cds--popover .cds--popover-caret,.cds--popover--top-right>.cds--popover .cds--popover-caret,.cds--popover--top>.cds--popover .cds--popover-caret{top:0;left:50%;width:var(--cds-popover-caret-width,.75rem);height:var(--cds-popover-caret-height,.375rem);-webkit-clip-path:polygon(0 0,50% 100%,100% 0);clip-path:polygon(0 0,50% 100%,100% 0);transform:translate(-50%,calc(-1 * var(--cds-popover-offset,0)))}.cds--popover--right>.cds--popover .cds--popover-content{top:50%;left:100%;transform:translate(var(--cds-popover-offset,0),-50%)}.cds--popover--right-top>.cds--popover .cds--popover-content{top:50%;left:100%;transform:translate(var(--cds-popover-offset,0),calc(.5 * var(--cds-popover-offset,0) * -1 - 16px))}.cds--popover--right-bottom>.cds--popover .cds--popover-content{bottom:50%;left:100%;transform:translate(var(--cds-popover-offset,0),calc(.5 * var(--cds-popover-offset,0) + 16px))}.cds--popover--right-bottom>.cds--popover .cds--popover-content::before,.cds--popover--right-top>.cds--popover .cds--popover-content::before,.cds--popover--right>.cds--popover .cds--popover-content::before{top:0;bottom:0;left:0;width:var(--cds-popover-offset,0);transform:translateX(-100%)}.cds--popover--right-bottom>.cds--popover .cds--popover-caret,.cds--popover--right-top>.cds--popover .cds--popover-caret,.cds--popover--right>.cds--popover .cds--popover-caret{top:50%;left:100%;width:var(--cds-popover-caret-height,.375rem);height:var(--cds-popover-caret-width,.75rem);-webkit-clip-path:polygon(0 50%,100% 0,100% 100%);clip-path:polygon(0 50%,100% 0,100% 100%);transform:translate(calc(var(--cds-popover-offset,0) - 100%),-50%)}.cds--popover--left>.cds--popover .cds--popover-content{top:50%;right:100%;transform:translate(calc(-1 * var(--cds-popover-offset,0) + .1px),-50%)}.cds--popover--left-top>.cds--popover .cds--popover-content{top:-50%;right:100%;transform:translate(calc(-1 * var(--cds-popover-offset,0)),calc(-.5 * var(--cds-popover-offset,0) + 16px))}.cds--popover--left-bottom>.cds--popover .cds--popover-content{right:100%;bottom:-50%;transform:translate(calc(-1 * var(--cds-popover-offset,0)),calc(.5 * var(--cds-popover-offset,0) - 16px))}.cds--popover--left-bottom>.cds--popover .cds--popover-content::before,.cds--popover--left-top>.cds--popover .cds--popover-content::before,.cds--popover--left>.cds--popover .cds--popover-content::before{top:0;right:0;bottom:0;width:var(--cds-popover-offset,0);transform:translateX(100%)}.cds--popover--left-bottom>.cds--popover .cds--popover-caret,.cds--popover--left-top>.cds--popover .cds--popover-caret,.cds--popover--left>.cds--popover .cds--popover-caret{top:50%;right:100%;width:var(--cds-popover-caret-height,.375rem);height:var(--cds-popover-caret-width,.75rem);-webkit-clip-path:polygon(0 0,100% 50%,0 100%);clip-path:polygon(0 0,100% 50%,0 100%);transform:translate(calc(-1 * var(--cds-popover-offset,0) + 100%),-50%)}.cds--popover--tab-tip>.cds--popover .cds--popover-content{border-radius:0}.cds--popover--tab-tip .cds--popover{will-change:filter}.cds--popover--tab-tip__button{box-sizing:border-box;padding:0;border:0;margin:0;font-family:inherit;font-size:100%;vertical-align:baseline;display:inline-block;padding:0;border:0;-webkit-appearance:none;-moz-appearance:none;appearance:none;background:0 0;cursor:pointer;text-align:start;width:100%;position:relative;display:inline-flex;width:2rem;height:2rem;align-items:center;justify-content:center}.cds--popover--tab-tip__button *,.cds--popover--tab-tip__button ::after,.cds--popover--tab-tip__button ::before{box-sizing:inherit}.cds--popover--tab-tip__button::-moz-focus-inner{border:0}.cds--popover--tab-tip__button:focus{outline:2px solid var(--cds-focus,#0f62fe);outline-offset:-2px}@media screen and (prefers-contrast){.cds--popover--tab-tip__button:focus{outline-style:dotted}}.cds--popover--tab-tip__button:hover{background-color:var(--cds-layer-hover)}.cds--popover--tab-tip.cds--popover--open .cds--popover--tab-tip__button{background:var(--cds-layer);box-shadow:0 2px 2px rgba(0,0,0,.2)}.cds--popover--tab-tip.cds--popover--open .cds--popover--tab-tip__button:not(:focus)::after{position:absolute;z-index:6001;bottom:0;width:100%;height:2px;background:var(--cds-layer);content:""}.cds--popover--tab-tip__button svg{fill:var(--cds-icon-primary,#161616)}.cds--tooltip{--cds-popover-offset:12px}.cds--tooltip-content{font-size:var(--cds-body-01-font-size,.875rem);font-weight:var(--cds-body-01-font-weight,400);line-height:var(--cds-body-01-line-height,1.42857);letter-spacing:var(--cds-body-01-letter-spacing,.16px);max-width:18rem;padding:var(--cds-tooltip-padding-block,1rem) var(--cds-tooltip-padding-inline,1rem);color:var(--cds-text-inverse,#fff)}.cds--icon-tooltip{--cds-tooltip-padding-block:0.125rem;--cds-popover-caret-width:0.5rem;--cds-popover-caret-height:0.25rem;--cds-popover-offset:0.5rem}.cds--icon-tooltip .cds--tooltip-content{font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);line-height:var(--cds-body-compact-01-line-height,1.28572);letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px)}.cds--definition-term{box-sizing:border-box;padding:0;border:0;margin:0;font-family:inherit;font-size:100%;vertical-align:baseline;display:inline-block;padding:0;border:0;-webkit-appearance:none;-moz-appearance:none;appearance:none;background:0 0;cursor:pointer;text-align:start;width:100%;border-bottom:1px dotted var(--cds-border-strong);border-radius:0;color:var(--cds-text-primary,#161616)}.cds--definition-term *,.cds--definition-term ::after,.cds--definition-term ::before{box-sizing:inherit}.cds--definition-term::-moz-focus-inner{border:0}.cds--definition-term:focus{outline:1px solid var(--cds-focus,#0f62fe);border-bottom-color:var(--cds-border-interactive,#0f62fe)}@media screen and (prefers-contrast){.cds--definition-term:focus{outline-style:dotted}}.cds--definition-term:hover{border-bottom-color:var(--cds-border-interactive,#0f62fe)}.cds--definition-tooltip{font-size:var(--cds-body-01-font-size,.875rem);font-weight:var(--cds-body-01-font-weight,400);line-height:var(--cds-body-01-line-height,1.42857);letter-spacing:var(--cds-body-01-letter-spacing,.16px);max-width:11rem;padding:.5rem 1rem}.cds--btn{--cds-layout-size-height-local:clamp(var(--cds-layout-size-height-min), var(--cds-layout-size-height, var(--cds-layout-size-height-lg)), var(--cds-layout-size-height-max));--cds-layout-density-padding-inline-local:clamp(var(--cds-layout-density-padding-inline-min), var(--cds-layout-density-padding-inline, var(--cds-layout-density-padding-inline-normal)), var(--cds-layout-density-padding-inline-max));--temp-1lh:(\n    var(--cds-body-compact-01-line-height, 1.28572) * 1em\n  );--temp-expressive-1lh:(\n    var(--cds-body-compact-02-line-height, 1.375) * 1em\n  );--temp-padding-block-max:calc(\n    (var(--cds-layout-size-height-lg) - var(--temp-1lh)) / 2 -\n      0.0625rem\n  );box-sizing:border-box;padding:0;border:0;margin:0;font-family:inherit;font-size:100%;vertical-align:baseline;font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);line-height:var(--cds-body-compact-01-line-height,1.28572);letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);position:relative;display:inline-flex;width:-moz-max-content;width:max-content;max-width:20rem;min-height:var(--cds-layout-size-height-local);flex-shrink:0;justify-content:space-between;margin:0;border-radius:0;cursor:pointer;outline:0;padding-block:min((var(--cds-layout-size-height-local) - var(--temp-1lh)) / 2 - .0625rem,var(--temp-padding-block-max));padding-inline-end:calc(var(--cds-layout-density-padding-inline-local) * 3 + 1rem - .0625rem);padding-inline-start:calc(var(--cds-layout-density-padding-inline-local) - .0625rem);text-align:left;text-decoration:none;transition:background 70ms cubic-bezier(0,0,.38,.9),box-shadow 70ms cubic-bezier(0,0,.38,.9),border-color 70ms cubic-bezier(0,0,.38,.9),outline 70ms cubic-bezier(0,0,.38,.9);vertical-align:top}.cds--btn *,.cds--btn ::after,.cds--btn ::before{box-sizing:inherit}.cds--btn.cds--btn--disabled,.cds--btn.cds--btn--disabled:focus,.cds--btn.cds--btn--disabled:hover,.cds--btn:disabled,.cds--btn:focus:disabled,.cds--btn:hover:disabled{border-color:var(--cds-button-disabled,#c6c6c6);background:var(--cds-button-disabled,#c6c6c6);box-shadow:none;color:var(--cds-text-on-color-disabled,#8d8d8d);cursor:not-allowed}.cds--btn .cds--btn__icon{position:absolute;top:min((var(--cds-layout-size-height-local) - 1rem) / 2 - .0625rem,var(--temp-padding-block-max));right:var(--cds-layout-density-padding-inline-local);width:1rem;height:1rem;flex-shrink:0;margin-block-start:.0625rem}.cds--btn::-moz-focus-inner{padding:0;border:0}.cds--btn--primary{border-width:1px;border-style:solid;border-color:transparent;background-color:var(--cds-button-primary,#0f62fe);color:var(--cds-text-on-color,#fff)}.cds--btn--primary:hover{background-color:var(--cds-button-primary-hover,#0050e6)}.cds--btn--primary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--primary:active{background-color:var(--cds-button-primary-active,#002d9c)}.cds--btn--primary .cds--btn__icon,.cds--btn--primary .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--primary:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--secondary{border-width:1px;border-style:solid;border-color:transparent;background-color:var(--cds-button-secondary,#393939);color:var(--cds-text-on-color,#fff)}.cds--btn--secondary:hover{background-color:var(--cds-button-secondary-hover,#474747)}.cds--btn--secondary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--secondary:active{background-color:var(--cds-button-secondary-active,#6f6f6f)}.cds--btn--secondary .cds--btn__icon,.cds--btn--secondary .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--secondary:focus,.cds--btn--secondary:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--tertiary{border-width:1px;border-style:solid;border-color:var(--cds-button-tertiary,#0f62fe);background-color:transparent;color:var(--cds-button-tertiary,#0f62fe)}.cds--btn--tertiary:hover{background-color:var(--cds-button-tertiary-hover,#0050e6)}.cds--btn--tertiary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--tertiary:active{background-color:var(--cds-button-tertiary-active,#002d9c)}.cds--btn--tertiary .cds--btn__icon,.cds--btn--tertiary .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--tertiary:hover{color:var(--cds-text-inverse,#fff)}.cds--btn--tertiary:focus{background-color:var(--cds-button-tertiary,#0f62fe);color:var(--cds-text-inverse,#fff)}.cds--btn--tertiary:active{border-color:transparent;background-color:var(--cds-button-tertiary-active,#002d9c);color:var(--cds-text-inverse,#fff)}.cds--btn--tertiary.cds--btn--disabled,.cds--btn--tertiary.cds--btn--disabled:focus,.cds--btn--tertiary.cds--btn--disabled:hover,.cds--btn--tertiary:disabled,.cds--btn--tertiary:focus:disabled,.cds--btn--tertiary:hover:disabled{background:0 0;color:var(--cds-text-on-color-disabled,#8d8d8d);outline:0}.cds--btn--ghost{border-width:1px;border-style:solid;border-color:transparent;background-color:transparent;color:var(--cds-link-primary,#0f62fe);padding-inline-end:calc(var(--cds-layout-density-padding-inline-local) - .0625rem)}.cds--btn--ghost:hover{background-color:var(--cds-layer-hover)}.cds--btn--ghost:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--ghost:active{background-color:var(--cds-layer-active)}.cds--btn--ghost .cds--btn__icon,.cds--btn--ghost .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--ghost .cds--btn__icon{position:static;margin-left:.5rem}.cds--btn--ghost:active,.cds--btn--ghost:hover{color:var(--cds-link-primary-hover,#0043ce)}.cds--btn--ghost:active{background-color:var(--cds-background-active,rgba(141,141,141,.5))}.cds--btn--ghost.cds--btn--disabled,.cds--btn--ghost.cds--btn--disabled:focus,.cds--btn--ghost.cds--btn--disabled:hover,.cds--btn--ghost:disabled,.cds--btn--ghost:focus:disabled,.cds--btn--ghost:hover:disabled{border-color:transparent;background:0 0;color:var(--cds-text-on-color-disabled,#8d8d8d);outline:0}.cds--btn--ghost:not([disabled]) svg{fill:var(--cds-icon-primary,#161616)}.cds--btn--icon-only{width:var(--cds-layout-size-height-local);height:var(--cds-layout-size-height-local);justify-content:center;padding:0;padding-block-start:min((var(--cds-layout-size-height-local) - 1rem) / 2 - .0625rem,var(--temp-padding-block-max))}.cds--btn--icon-only>:first-child{min-width:1rem;margin-block-start:.0625rem}.cds--btn--icon-only .cds--btn__icon{position:static}.cds--btn--icon-only.cds--btn--danger--ghost .cds--btn__icon,.cds--btn--icon-only.cds--btn--ghost .cds--btn__icon{margin:0}.cds--btn--icon-only.cds--btn--selected{background:var(--cds-background-selected,rgba(141,141,141,.2))}.cds--btn path[data-icon-path=inner-path]{fill:none}.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon,.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:var(--cds-icon-primary,#161616)}.cds--btn--ghost.cds--btn--icon-only[disabled] .cds--btn__icon,.cds--btn--ghost.cds--btn--icon-only[disabled] .cds--btn__icon path:not([data-icon-path]):not([fill=none]),.cds--btn.cds--btn--icon-only.cds--btn--ghost[disabled]:hover .cds--btn__icon{fill:var(--cds-icon-on-color-disabled,#8d8d8d)}.cds--btn--ghost.cds--btn--icon-only[disabled]{cursor:not-allowed}.cds--icon-tooltip--disabled .cds--tooltip-trigger__wrapper{cursor:not-allowed}.cds--icon-tooltip--disabled .cds--btn--icon-only[disabled]{pointer-events:none}.cds--btn--danger{border-width:1px;border-style:solid;border-color:transparent;background-color:var(--cds-button-danger-primary,#da1e28);color:var(--cds-text-on-color,#fff)}.cds--btn--danger:hover{background-color:var(--cds-button-danger-hover,#b81921)}.cds--btn--danger:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--danger:active{background-color:var(--cds-button-danger-active,#750e13)}.cds--btn--danger .cds--btn__icon,.cds--btn--danger .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--danger:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary{border-width:1px;border-style:solid;border-color:var(--cds-button-danger-secondary,#da1e28);background-color:transparent;color:var(--cds-button-danger-secondary,#da1e28)}.cds--btn--danger--tertiary:hover{background-color:var(--cds-button-danger-hover,#b81921)}.cds--btn--danger--tertiary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--danger--tertiary:active{background-color:var(--cds-button-danger-active,#750e13)}.cds--btn--danger--tertiary .cds--btn__icon,.cds--btn--danger--tertiary .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--danger--tertiary:hover{border-color:var(--cds-button-danger-hover,#b81921);color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary:focus{background-color:var(--cds-button-danger-primary,#da1e28);color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary:active{border-color:var(--cds-button-danger-active,#750e13);background-color:var(--cds-button-danger-active,#750e13);color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary.cds--btn--disabled,.cds--btn--danger--tertiary.cds--btn--disabled:focus,.cds--btn--danger--tertiary.cds--btn--disabled:hover,.cds--btn--danger--tertiary:disabled,.cds--btn--danger--tertiary:focus:disabled,.cds--btn--danger--tertiary:hover:disabled{background:0 0;color:var(--cds-text-on-color-disabled,#8d8d8d);outline:0}.cds--btn--danger--ghost{border-width:1px;border-style:solid;border-color:transparent;background-color:transparent;color:var(--cds-button-danger-secondary,#da1e28);padding-inline-end:calc(var(--cds-layout-density-padding-inline-local) - .0625rem)}.cds--btn--danger--ghost:hover{background-color:var(--cds-button-danger-hover,#b81921)}.cds--btn--danger--ghost:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--danger--ghost:active{background-color:var(--cds-button-danger-active,#750e13)}.cds--btn--danger--ghost .cds--btn__icon,.cds--btn--danger--ghost .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--danger--ghost .cds--btn__icon{position:static;margin-left:.5rem}.cds--btn--danger--ghost:active,.cds--btn--danger--ghost:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--danger--ghost.cds--btn--disabled,.cds--btn--danger--ghost.cds--btn--disabled:focus,.cds--btn--danger--ghost.cds--btn--disabled:hover,.cds--btn--danger--ghost:disabled,.cds--btn--danger--ghost:focus:disabled,.cds--btn--danger--ghost:hover:disabled{border-color:transparent;background:0 0;color:var(--cds-text-disabled,rgba(22,22,22,.25));outline:0}.cds--btn--expressive{font-size:var(--cds-body-compact-02-font-size,1rem);font-weight:var(--cds-body-compact-02-font-weight,400);line-height:var(--cds-body-compact-02-line-height,1.375);letter-spacing:var(--cds-body-compact-02-letter-spacing,0);padding-block:min((var(--cds-layout-size-height-local) - var(--temp-expressive-1lh)) / 2 - .0625rem,var(--temp-padding-block-max))}.cds--btn--icon-only.cds--btn--expressive{padding:12px 13px}.cds--btn.cds--btn--expressive .cds--btn__icon{width:1.25rem;height:1.25rem}.cds--btn-set .cds--btn.cds--btn--expressive{max-width:20rem}.cds--btn.cds--skeleton{position:relative;padding:0;border:none;background:var(--cds-skeleton-background,#e8e8e8);box-shadow:none;pointer-events:none;width:9.375rem}.cds--btn.cds--skeleton:active,.cds--btn.cds--skeleton:focus,.cds--btn.cds--skeleton:hover{border:none;cursor:default;outline:0}.cds--btn.cds--skeleton::before{position:absolute;width:100%;height:100%;animation:3s ease-in-out skeleton infinite;background:var(--cds-skeleton-element,#c6c6c6);content:"";will-change:transform-origin,transform,opacity}@media (prefers-reduced-motion:reduce){.cds--btn.cds--skeleton::before{animation:none}}.cds--btn-set{display:flex}.cds--btn-set--stacked{flex-direction:column}.cds--btn-set .cds--btn{width:100%;max-width:12.25rem}.cds--btn-set .cds--btn:not(:focus){box-shadow:-.0625rem 0 0 0 var(--cds-button-separator,#e0e0e0)}.cds--btn-set .cds--btn:first-of-type:not(:focus){box-shadow:inherit}.cds--btn-set .cds--btn:focus+.cds--btn{box-shadow:inherit}.cds--btn-set--stacked .cds--btn:not(:focus){box-shadow:0 -.0625rem 0 0 var(--cds-button-separator,#e0e0e0)}.cds--btn-set--stacked .cds--btn:first-of-type:not(:focus){box-shadow:inherit}.cds--btn-set .cds--btn.cds--btn--disabled{box-shadow:-.0625rem 0 0 0 var(--cds-icon-on-color-disabled,#8d8d8d)}.cds--btn-set .cds--btn.cds--btn--disabled:first-of-type{box-shadow:none}.cds--btn-set--stacked .cds--btn.cds--btn--disabled{box-shadow:0 -.0625rem 0 0 var(--cds-layer-selected-disabled,#8d8d8d)}.cds--btn-set--stacked .cds--btn.cds--btn--disabled:first-of-type{box-shadow:none}@media screen and (-ms-high-contrast:active),(forced-colors:active){.cds--btn:focus{color:Highlight;outline:1px solid Highlight}}@media screen and (-ms-high-contrast:active),(forced-colors:active){.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon,.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:ButtonText}}.cds--content-switcher,:host(cds-content-switcher){--cds-layout-size-height-local:clamp(max(var(--cds-layout-size-height-min), var(--cds-layout-size-height-sm)), var(--cds-layout-size-height, var(--cds-layout-size-height-md)), min(var(--cds-layout-size-height-max), var(--cds-layout-size-height-lg)));--cds-layout-density-padding-inline-local:clamp(var(--cds-layout-density-padding-inline-min), var(--cds-layout-density-padding-inline, var(--cds-layout-density-padding-inline-normal)), var(--cds-layout-density-padding-inline-max));display:flex;width:100%;height:var(--cds-layout-size-height-local);justify-content:space-evenly}.cds--content-switcher-btn{font-family:\'IBM Plex Sans\',system-ui,-apple-system,BlinkMacSystemFont,\'.SFNSText-Regular\',sans-serif;outline:2px solid transparent;outline-offset:-2px;font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);line-height:var(--cds-body-compact-01-line-height,1.28572);letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);position:relative;display:inline-flex;overflow:hidden;border:none;border-top:.0625rem solid var(--cds-border-inverse,#161616);border-bottom:.0625rem solid var(--cds-border-inverse,#161616);margin:0;background-color:transparent;color:var(--cds-text-secondary,#525252);text-align:left;text-decoration:none;transition:all 150ms cubic-bezier(.2,0,.38,.9);white-space:nowrap}.cds--content-switcher-btn html{font-size:100%}.cds--content-switcher-btn body{font-weight:400;font-family:\'IBM Plex Sans\',system-ui,-apple-system,BlinkMacSystemFont,\'.SFNSText-Regular\',sans-serif;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;text-rendering:optimizeLegibility}.cds--content-switcher-btn code{font-family:\'IBM Plex Mono\',system-ui,-apple-system,BlinkMacSystemFont,\'.SFNSText-Regular\',monospace}.cds--content-switcher-btn strong{font-weight:600}.cds--content-switcher-btn::after{position:absolute;top:0;left:0;display:block;width:100%;height:100%;background-color:var(--cds-layer-selected-inverse,#161616);content:"";transform:scaleY(0);transform-origin:bottom;transition:all 150ms cubic-bezier(.2,0,.38,.9)}@media (prefers-reduced-motion:reduce){.cds--content-switcher-btn::after{transition:none}}.cds--content-switcher-btn:disabled::after{display:none}.cds--content-switcher-btn:focus{z-index:3;border-color:var(--cds-focus,#0f62fe);box-shadow:inset 0 0 0 2px var(--cds-focus,#0f62fe),inset 0 0 0 3px var(--cds-focus-inset,#fff)}.cds--content-switcher-btn:focus::after{-webkit-clip-path:inset(3px 3px 3px 3px);clip-path:inset(3px 3px 3px 3px)}.cds--content-switcher-btn:hover{color:var(--cds-text-primary,#161616);cursor:pointer}.cds--content-switcher-btn:active,.cds--content-switcher-btn:hover{z-index:3;background-color:var(--cds-layer-hover);color:var(--cds-text-primary,#161616)}.cds--content-switcher-btn:disabled{border-color:var(--cds-border-disabled,#c6c6c6);background-color:transparent;color:var(--cds-text-disabled,rgba(22,22,22,.25))}.cds--content-switcher-btn:disabled:hover{cursor:not-allowed}.cds--content-switcher-btn:disabled:first-child,.cds--content-switcher-btn:disabled:last-child{border-color:var(--cds-border-disabled,#c6c6c6)}.cds--content-switcher:not(.cds--content-switcher--icon-only) .cds--content-switcher-btn,:not(.cds--content-switcher--icon-only):host(cds-content-switcher) .cds--content-switcher-btn{width:100%;align-items:center;padding:.5rem var(--cds-layout-density-padding-inline-local)}.cds--content-switcher:not(.cds--content-switcher--icon-only) .cds--content-switcher-btn:first-child,:not(.cds--content-switcher--icon-only):host(cds-content-switcher) .cds--content-switcher-btn:first-child{border-left:.0625rem solid var(--cds-border-inverse,#161616);border-bottom-left-radius:.25rem;border-top-left-radius:.25rem}.cds--content-switcher:not(.cds--content-switcher--icon-only) .cds--content-switcher-btn:first-child:disabled,:not(.cds--content-switcher--icon-only):host(cds-content-switcher) .cds--content-switcher-btn:first-child:disabled{border-color:var(--cds-border-disabled,#c6c6c6);color:var(--cds-text-disabled,rgba(22,22,22,.25))}.cds--content-switcher:not(.cds--content-switcher--icon-only) .cds--content-switcher-btn:last-child,:not(.cds--content-switcher--icon-only):host(cds-content-switcher) .cds--content-switcher-btn:last-child{border-right:.0625rem solid var(--cds-border-inverse,#161616);border-bottom-right-radius:.25rem;border-top-right-radius:.25rem}.cds--content-switcher:not(.cds--content-switcher--icon-only) .cds--content-switcher-btn:last-child:disabled,:not(.cds--content-switcher--icon-only):host(cds-content-switcher) .cds--content-switcher-btn:last-child:disabled{border-color:var(--cds-border-disabled,#c6c6c6);color:var(--cds-text-disabled,rgba(22,22,22,.25))}.cds--content-switcher .cds--content-switcher-btn.cds--content-switcher--selected,.cds--content-switcher .cds--content-switcher-btn.cds--content-switcher--selected:first-child,.cds--content-switcher .cds--content-switcher-btn.cds--content-switcher--selected:last-child,:host(cds-content-switcher) .cds--content-switcher-btn.cds--content-switcher--selected{border:0}.cds--content-switcher-btn::before{position:absolute;z-index:2;left:0;display:block;width:.0625rem;height:1rem;background-color:var(--cds-border-subtle);content:""}.cds--content-switcher:not(.cds--content-switcher--icon-only) .cds--content-switcher-btn:first-of-type::before,:not(.cds--content-switcher--icon-only):host(cds-content-switcher) .cds--content-switcher-btn:first-of-type::before{display:none}.cds--content-switcher--selected+.cds--content-switcher-btn::before,.cds--content-switcher--selected::before,.cds--content-switcher-btn:focus+.cds--content-switcher-btn::before,.cds--content-switcher-btn:focus::before,.cds--content-switcher-btn:hover+.cds--content-switcher-btn::before,.cds--content-switcher-btn:hover::before{background-color:transparent}.cds--content-switcher-btn:disabled::before,.cds--content-switcher-btn:disabled:hover+.cds--content-switcher-btn:disabled::before{background-color:var(--cds-border-disabled,#c6c6c6)}.cds--content-switcher-btn.cds--content-switcher--selected:disabled+.cds--content-switcher-btn::before,.cds--content-switcher-btn.cds--content-switcher--selected:disabled:hover+.cds--content-switcher-btn::before{background-color:transparent}.cds--content-switcher__icon{fill:var(--cds-icon-secondary,#525252);transition:fill 70ms cubic-bezier(.2,0,.38,.9)}.cds--content-switcher__icon+span{margin-left:.5rem}.cds--content-switcher__label{z-index:1;overflow:hidden;max-width:100%;text-overflow:ellipsis;white-space:nowrap}.cds--content-switcher-btn:focus .cds--content-switcher__icon,.cds--content-switcher-btn:hover .cds--content-switcher__icon{fill:var(--cds-icon-primary,#161616)}.cds--content-switcher-btn.cds--content-switcher--selected{z-index:3;background-color:var(--cds-layer-selected-inverse,#161616);color:var(--cds-text-inverse,#fff)}.cds--content-switcher-btn.cds--content-switcher--selected:disabled{background-color:var(--cds-layer-selected-disabled,#8d8d8d);color:var(--cds-text-disabled,rgba(22,22,22,.25))}.cds--content-switcher-btn.cds--content-switcher--selected::after{transform:scaleY(1)}.cds--content-switcher-btn.cds--content-switcher--selected .cds--content-switcher__icon{fill:var(--cds-icon-inverse,#fff)}@media screen and (-ms-high-contrast:active),(forced-colors:active){.cds--content-switcher-btn:focus{color:Highlight;outline:1px solid Highlight}}.cds--content-switcher--icon-only,:host(cds-content-switcher[icon]){justify-content:flex-start}.cds--content-switcher--icon-only .cds--content-switcher-popover__wrapper:first-child .cds--content-switcher-btn,:host(cds-content-switcher[icon]) .cds--content-switcher-popover__wrapper:first-child .cds--content-switcher-btn{border-left:.0625rem solid var(--cds-border-inverse,#161616);border-bottom-left-radius:.25rem;border-top-left-radius:.25rem}.cds--content-switcher--icon-only .cds--content-switcher-popover__wrapper:first-child .cds--content-switcher--selected[disabled],.cds--content-switcher--icon-only .cds--content-switcher-popover__wrapper:last-child .cds--content-switcher--selected[disabled],:host(cds-content-switcher[icon]) .cds--content-switcher-popover__wrapper:first-child .cds--content-switcher--selected[disabled],:host(cds-content-switcher[icon]) .cds--content-switcher-popover__wrapper:last-child .cds--content-switcher--selected[disabled]{border-color:var(--cds-layer-selected-disabled,#8d8d8d)}.cds--content-switcher--icon-only .cds--content-switcher-popover__wrapper:last-child .cds--content-switcher-btn,:host(cds-content-switcher[icon]) .cds--content-switcher-popover__wrapper:last-child .cds--content-switcher-btn{border-right:.0625rem solid var(--cds-border-inverse,#161616);border-bottom-right-radius:.25rem;border-top-right-radius:.25rem}.cds--content-switcher--icon-only .cds--content-switcher-popover__wrapper:first-child .cds--content-switcher-btn.cds--content-switcher--selected,.cds--content-switcher--icon-only .cds--content-switcher-popover__wrapper:last-child .cds--content-switcher-btn.cds--content-switcher--selected,:host(cds-content-switcher[icon]) .cds--content-switcher-popover__wrapper:first-child .cds--content-switcher-btn.cds--content-switcher--selected,:host(cds-content-switcher[icon]) .cds--content-switcher-popover__wrapper:last-child .cds--content-switcher-btn.cds--content-switcher--selected{border-color:var(--cds-background,#fff)}.cds--content-switcher--lg .cds--content-switcher-btn{padding-right:.875rem;padding-left:.875rem}.cds--content-switcher--lg .cds--content-switcher-btn svg{width:20px;height:20px}.cds--content-switcher--icon-only .cds--content-switcher-btn svg,:host(cds-content-switcher[icon]) .cds--content-switcher-btn svg{fill:var(--cds-icon-primary,#161616)}.cds--content-switcher--icon-only .cds--content-switcher-btn.cds--content-switcher--selected svg,:host(cds-content-switcher[icon]) .cds--content-switcher-btn.cds--content-switcher--selected svg{z-index:1;fill:var(--cds-icon-inverse,#fff)}.cds--content-switcher--icon-only.cds--content-switcher--sm .cds--btn--sm{height:2rem}.cds--content-switcher--icon-only .cds--content-switcher-popover__wrapper:first-of-type .cds--content-switcher-btn::before,:host(cds-content-switcher[icon]) .cds--content-switcher-popover__wrapper:first-of-type .cds--content-switcher-btn::before{display:none}.cds--content-switcher--selected::before,.cds--content-switcher-btn:focus::before,.cds--content-switcher-btn:hover::before,.cds--content-switcher-popover--selected+.cds--content-switcher-popover__wrapper .cds--content-switcher-btn::before,.cds--content-switcher-popover__wrapper:focus-within+.cds--content-switcher-popover__wrapper .cds--content-switcher-btn::before,.cds--content-switcher-popover__wrapper:not(.cds--content-switcher-popover--disabled):hover+.cds--content-switcher-popover__wrapper .cds--content-switcher-btn::before{background-color:transparent}.cds--content-switcher--icon-only .cds--content-switcher-btn[disabled],:host(cds-content-switcher[icon]) .cds--content-switcher-btn[disabled]{border-color:var(--cds-border-inverse,#161616)}.cds--content-switcher--icon-only .cds--content-switcher-btn[disabled] svg,:host(cds-content-switcher[icon]) .cds--content-switcher-btn[disabled] svg{fill:var(--cds-icon-disabled,rgba(22,22,22,.25))}.cds--content-switcher--icon-only .cds--content-switcher-btn[disabled]:not(.cds--content-switcher--selected):hover,.cds--content-switcher--icon-only .cds--content-switcher-popover--selected+.cds--content-switcher-popover--disabled .cds--content-switcher-btn[disabled]:hover::before,:host(cds-content-switcher[icon]) .cds--content-switcher-btn[disabled]:not(.cds--content-switcher--selected):hover,:host(cds-content-switcher[icon]) .cds--content-switcher-popover--selected+.cds--content-switcher-popover--disabled .cds--content-switcher-btn[disabled]:hover::before{background-color:transparent}.cds--content-switcher--icon-only .cds--content-switcher-btn[disabled]:hover::before,:host(cds-content-switcher[icon]) .cds--content-switcher-btn[disabled]:hover::before{background-color:var(--cds-border-subtle)}:host(cds-content-switcher){--cds-layout-size-height-xs:1.5rem;--cds-layout-size-height-sm:2rem;--cds-layout-size-height-md:2.5rem;--cds-layout-size-height-lg:3rem;--cds-layout-size-height-xl:4rem;--cds-layout-size-height-2xl:5rem;--cds-layout-size-height-min:0px;--cds-layout-size-height-max:999999999px;--cds-layout-density-padding-inline-condensed:0.5rem;--cds-layout-density-padding-inline-normal:1rem;--cds-layout-density-padding-inline-min:0px;--cds-layout-density-padding-inline-max:999999999px}:host(cds-content-switcher-item){outline:0;width:100%}:host(cds-content-switcher-item) .cds--content-switcher-btn{height:100%;width:100%;align-items:center;padding:.5rem var(--cds-layout-density-padding-inline-local)}:host(cds-content-switcher-item) .cds--content-switcher-btn:first-child,:host(cds-content-switcher-item) .cds--content-switcher-btn:last-child{border-radius:0;border-left:none;border-right:none}:host(cds-content-switcher-item) .cds--content-switcher-btn::before{content:"";display:block;height:1rem;width:.0625rem;background-color:var(--cds-border-subtle);position:absolute;z-index:2;left:0}:host(cds-content-switcher-item) .cds--content-switcher-btn.cds--content-switcher--selected::before,:host(cds-content-switcher-item) .cds--content-switcher-btn:focus::before,:host(cds-content-switcher-item) .cds--content-switcher-btn:hover::before{background-color:transparent}:host(cds-content-switcher-item) .cds--content-switcher-btn:disabled{border-top-color:var(--cds-border-inverse,#161616);border-bottom-color:var(--cds-border-inverse,#161616)}:host(cds-content-switcher-item)[icon]{width:initial}:host(cds-content-switcher-item)[icon] .cds--content-switcher-btn{padding-left:.6875rem;padding-right:.6875rem;height:2.5rem}:host(cds-content-switcher-item)[icon] .cds--content-switcher__label{display:flex;align-items:center}:host(cds-content-switcher-item[hide-divider]) .cds--content-switcher-btn::before{background-color:transparent}:host(cds-content-switcher-item:first-of-type) .cds--content-switcher-btn{border-top-left-radius:.25rem;border-bottom-left-radius:.25rem;border-left:.0625rem solid var(--cds-border-inverse,#161616)}:host(cds-content-switcher-item:first-of-type) .cds--content-switcher-btn::before{content:none}:host(cds-content-switcher-item:last-of-type) .cds--content-switcher-btn{border-top-right-radius:.25rem;border-bottom-right-radius:.25rem;border-right:.0625rem solid var(--cds-border-inverse,#161616)}',
]);
