/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { css } from 'lit';
export default css([
  ".cds--assistive-text,.cds--visually-hidden{position:absolute;overflow:hidden;width:1px;height:1px;padding:0;border:0;margin:-1px;clip:rect(0,0,0,0);visibility:inherit;white-space:nowrap}.cds--layout--size-xs{--cds-layout-size-height-context:var(--cds-layout-size-height-xs, 1.5rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-xs{--cds-layout-size-height:var(--cds-layout-size-height-context, var(--cds-layout-size-height-xs, 1.5rem))}.cds--layout-constraint--size__min-xs{--cds-layout-size-height-min:var(--cds-layout-size-height-xs, 1.5rem)}.cds--layout-constraint--size__max-xs{--cds-layout-size-height-max:var(--cds-layout-size-height-xs, 1.5rem)}.cds--layout--size-sm{--cds-layout-size-height-context:var(--cds-layout-size-height-sm, 2rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-sm{--cds-layout-size-height:var(--cds-layout-size-height-context, var(--cds-layout-size-height-sm, 2rem))}.cds--layout-constraint--size__min-sm{--cds-layout-size-height-min:var(--cds-layout-size-height-sm, 2rem)}.cds--layout-constraint--size__max-sm{--cds-layout-size-height-max:var(--cds-layout-size-height-sm, 2rem)}.cds--layout--size-md{--cds-layout-size-height-context:var(--cds-layout-size-height-md, 2.5rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-md{--cds-layout-size-height:var(--cds-layout-size-height-context, var(--cds-layout-size-height-md, 2.5rem))}.cds--layout-constraint--size__min-md{--cds-layout-size-height-min:var(--cds-layout-size-height-md, 2.5rem)}.cds--layout-constraint--size__max-md{--cds-layout-size-height-max:var(--cds-layout-size-height-md, 2.5rem)}.cds--layout--size-lg{--cds-layout-size-height-context:var(--cds-layout-size-height-lg, 3rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-lg{--cds-layout-size-height:var(--cds-layout-size-height-context, var(--cds-layout-size-height-lg, 3rem))}.cds--layout-constraint--size__min-lg{--cds-layout-size-height-min:var(--cds-layout-size-height-lg, 3rem)}.cds--layout-constraint--size__max-lg{--cds-layout-size-height-max:var(--cds-layout-size-height-lg, 3rem)}.cds--layout--size-xl{--cds-layout-size-height-context:var(--cds-layout-size-height-xl, 4rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-xl{--cds-layout-size-height:var(--cds-layout-size-height-context, var(--cds-layout-size-height-xl, 4rem))}.cds--layout-constraint--size__min-xl{--cds-layout-size-height-min:var(--cds-layout-size-height-xl, 4rem)}.cds--layout-constraint--size__max-xl{--cds-layout-size-height-max:var(--cds-layout-size-height-xl, 4rem)}.cds--layout--size-2xl{--cds-layout-size-height-context:var(--cds-layout-size-height-2xl, 5rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-2xl{--cds-layout-size-height:var(--cds-layout-size-height-context, var(--cds-layout-size-height-2xl, 5rem))}.cds--layout-constraint--size__min-2xl{--cds-layout-size-height-min:var(--cds-layout-size-height-2xl, 5rem)}.cds--layout-constraint--size__max-2xl{--cds-layout-size-height-max:var(--cds-layout-size-height-2xl, 5rem)}.cds--layout--density-condensed{--cds-layout-density-padding-inline-context:var(--cds-layout-density-padding-inline-condensed, 0.5rem);--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context)}.cds--layout-constraint--density__default-condensed{--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context, var(--cds-layout-density-padding-inline-condensed, 0.5rem))}.cds--layout-constraint--density__min-condensed{--cds-layout-density-padding-inline-min:var(--cds-layout-density-padding-inline-condensed, 0.5rem)}.cds--layout-constraint--density__max-condensed{--cds-layout-density-padding-inline-max:var(--cds-layout-density-padding-inline-condensed, 0.5rem)}.cds--layout--density-normal{--cds-layout-density-padding-inline-context:var(--cds-layout-density-padding-inline-normal, 1rem);--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context)}.cds--layout-constraint--density__default-normal{--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context, var(--cds-layout-density-padding-inline-normal, 1rem))}.cds--layout-constraint--density__min-normal{--cds-layout-density-padding-inline-min:var(--cds-layout-density-padding-inline-normal, 1rem)}.cds--layout-constraint--density__max-normal{--cds-layout-density-padding-inline-max:var(--cds-layout-density-padding-inline-normal, 1rem)}:root{--cds-layout-size-height-xs:1.5rem;--cds-layout-size-height-sm:2rem;--cds-layout-size-height-md:2.5rem;--cds-layout-size-height-lg:3rem;--cds-layout-size-height-xl:4rem;--cds-layout-size-height-2xl:5rem;--cds-layout-size-height-min:0px;--cds-layout-size-height-max:999999999px;--cds-layout-density-padding-inline-condensed:0.5rem;--cds-layout-density-padding-inline-normal:1rem;--cds-layout-density-padding-inline-min:0px;--cds-layout-density-padding-inline-max:999999999px}:root{--cds-layer:var(--cds-layer-01, #f4f4f4);--cds-layer-active:var(--cds-layer-active-01, #c6c6c6);--cds-layer-hover:var(--cds-layer-hover-01, #e8e8e8);--cds-layer-selected:var(--cds-layer-selected-01, #e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-01, #d1d1d1);--cds-layer-accent:var(--cds-layer-accent-01, #e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-01, #d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-01, #a8a8a8);--cds-field:var(--cds-field-01, #f4f4f4);--cds-field-hover:var(--cds-field-hover-01, #e8e8e8);--cds-border-subtle:var(--cds-border-subtle-00, #e0e0e0);--cds-border-subtle-selected:var(--cds-border-subtle-selected-01, #c6c6c6);--cds-border-strong:var(--cds-border-strong-01, #8d8d8d);--cds-border-tile:var(--cds-border-tile-01, #c6c6c6)}.cds--layer-one{--cds-layer:var(--cds-layer-01, #f4f4f4);--cds-layer-active:var(--cds-layer-active-01, #c6c6c6);--cds-layer-hover:var(--cds-layer-hover-01, #e8e8e8);--cds-layer-selected:var(--cds-layer-selected-01, #e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-01, #d1d1d1);--cds-layer-accent:var(--cds-layer-accent-01, #e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-01, #d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-01, #a8a8a8);--cds-field:var(--cds-field-01, #f4f4f4);--cds-field-hover:var(--cds-field-hover-01, #e8e8e8);--cds-border-subtle:var(--cds-border-subtle-00, #e0e0e0);--cds-border-subtle-selected:var(--cds-border-subtle-selected-01, #c6c6c6);--cds-border-strong:var(--cds-border-strong-01, #8d8d8d);--cds-border-tile:var(--cds-border-tile-01, #c6c6c6)}.cds--layer-two{--cds-layer:var(--cds-layer-02, #ffffff);--cds-layer-active:var(--cds-layer-active-02, #c6c6c6);--cds-layer-hover:var(--cds-layer-hover-02, #e8e8e8);--cds-layer-selected:var(--cds-layer-selected-02, #e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-02, #d1d1d1);--cds-layer-accent:var(--cds-layer-accent-02, #e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-02, #d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-02, #a8a8a8);--cds-field:var(--cds-field-02, #ffffff);--cds-field-hover:var(--cds-field-hover-02, #e8e8e8);--cds-border-subtle:var(--cds-border-subtle-01, #c6c6c6);--cds-border-subtle-selected:var(--cds-border-subtle-selected-02, #c6c6c6);--cds-border-strong:var(--cds-border-strong-02, #8d8d8d);--cds-border-tile:var(--cds-border-tile-02, #a8a8a8)}.cds--layer-three{--cds-layer:var(--cds-layer-03, #f4f4f4);--cds-layer-active:var(--cds-layer-active-03, #c6c6c6);--cds-layer-hover:var(--cds-layer-hover-03, #e8e8e8);--cds-layer-selected:var(--cds-layer-selected-03, #e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-03, #d1d1d1);--cds-layer-accent:var(--cds-layer-accent-03, #e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-03, #d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-03, #a8a8a8);--cds-field:var(--cds-field-03, #f4f4f4);--cds-field-hover:var(--cds-field-hover-03, #e8e8e8);--cds-border-subtle:var(--cds-border-subtle-02, #e0e0e0);--cds-border-subtle-selected:var(--cds-border-subtle-selected-03, #c6c6c6);--cds-border-strong:var(--cds-border-strong-03, #8d8d8d);--cds-border-tile:var(--cds-border-tile-03, #c6c6c6)}@keyframes hide-feedback{0%{opacity:1;visibility:inherit}100%{opacity:0;visibility:hidden}}@keyframes show-feedback{0%{opacity:0;visibility:hidden}100%{opacity:1;visibility:inherit}}@keyframes skeleton{0%{opacity:.3;transform:scaleX(0);transform-origin:right}20%{opacity:1;transform:scaleX(1);transform-origin:right}28%{transform:scaleX(1);transform-origin:left}51%{transform:scaleX(0);transform-origin:left}58%{transform:scaleX(0);transform-origin:left}82%{transform:scaleX(1);transform-origin:left}83%{transform:scaleX(1);transform-origin:right}96%{transform:scaleX(0);transform-origin:right}100%{opacity:.3;transform:scaleX(0);transform-origin:right}}.cds--popover-container{position:relative;display:inline-block}.cds--popover--high-contrast .cds--popover{--cds-popover-background-color:var(--cds-background-inverse, #393939);--cds-popover-text-color:var(--cds-text-inverse, #ffffff)}.cds--popover--drop-shadow .cds--popover{--cds-popover-drop-shadow:drop-shadow(0 2px 2px rgba(0, 0, 0, 0.2))}.cds--popover--caret{--cds-popover-offset:0.625rem}.cds--popover{position:absolute;z-index:6000;filter:var(--cds-popover-drop-shadow, none);inset:0;pointer-events:none}.cds--popover-content{box-sizing:border-box;padding:0;border:0;margin:0;font-family:inherit;font-size:100%;vertical-align:baseline;position:absolute;z-index:6000;display:none;width:-moz-max-content;width:max-content;max-width:23rem;background-color:var(--cds-popover-background-color,var(--cds-layer));border-radius:var(--cds-popover-border-radius,2px);color:var(--cds-popover-text-color,var(--cds-text-primary,#161616));pointer-events:auto}.cds--popover-content *,.cds--popover-content ::after,.cds--popover-content ::before{box-sizing:inherit}.cds--popover--open>.cds--popover>.cds--popover-content{display:block}.cds--popover-content::before{position:absolute;display:none;content:\"\"}.cds--popover--open>.cds--popover>.cds--popover-content::before{display:block}.cds--popover-caret{position:absolute;z-index:6000;display:none;background-color:var(--cds-popover-background-color,var(--cds-layer));will-change:transform}.cds--popover--open>.cds--popover>.cds--popover-caret{display:block}.cds--popover--tab-tip>.cds--popover .cds--popover-caret{display:none}.cds--popover--bottom>.cds--popover .cds--popover-content{bottom:0;right:50%;transform:translate(50%,calc(100% + var(--cds-popover-offset,0)))}.cds--popover--bottom-left>.cds--popover .cds--popover-content{bottom:0;right:0;transform:translate(calc(-1*(-1 * var(--cds-popover-offset,0))),calc(100% + var(--cds-popover-offset,0)))}.cds--popover--bottom-right>.cds--popover .cds--popover-content{left:0;bottom:0;transform:translate(var(--cds-popover-offset,0),calc(-1*(100% + var(--cds-popover-offset,0))))}.cds--popover--bottom-left>.cds--popover .cds--popover-content::before,.cds--popover--bottom-right>.cds--popover .cds--popover-content::before,.cds--popover--bottom>.cds--popover .cds--popover-content::before{top:0;left:0;right:0;height:var(--cds-popover-offset,0);transform:translateY(-100%)}.cds--popover--bottom-left>.cds--popover .cds--popover-caret,.cds--popover--bottom-right>.cds--popover .cds--popover-caret,.cds--popover--bottom>.cds--popover .cds--popover-caret{bottom:0;right:50%;width:var(--cds-popover-caret-width,.75rem);height:var(--cds-popover-caret-height,.375rem);-webkit-clip-path:polygon(0 100%,50% 0,100% 100%);clip-path:polygon(0 100%,50% 0,100% 100%);transform:translate(50%,var(--cds-popover-offset,0))}.cds--popover--top>.cds--popover .cds--popover-content{top:0;right:50%;transform:translate(50%,calc(-100% - var(--cds-popover-offset,0)))}.cds--popover--top-left>.cds--popover .cds--popover-content{top:0;right:0;transform:translate(calc(-1*(-1 * var(--cds-popover-offset,0))),calc(-100% - var(--cds-popover-offset,0)))}.cds--popover--top-right>.cds--popover .cds--popover-content{top:0;left:0;transform:translate(var(--cds-popover-offset,0),calc(-1*(-100% - var(--cds-popover-offset,0))))}.cds--popover--top-left>.cds--popover .cds--popover-content::before,.cds--popover--top-right>.cds--popover .cds--popover-content::before,.cds--popover--top>.cds--popover .cds--popover-content::before{left:0;bottom:0;right:0;height:var(--cds-popover-offset,0);transform:translateY(100%)}.cds--popover--top-left>.cds--popover .cds--popover-caret,.cds--popover--top-right>.cds--popover .cds--popover-caret,.cds--popover--top>.cds--popover .cds--popover-caret{top:0;right:50%;width:var(--cds-popover-caret-width,.75rem);height:var(--cds-popover-caret-height,.375rem);-webkit-clip-path:polygon(0 0,50% 100%,100% 0);clip-path:polygon(0 0,50% 100%,100% 0);transform:translate(50%,calc(-1 * var(--cds-popover-offset,0)))}.cds--popover--right>.cds--popover .cds--popover-content{top:50%;right:100%;transform:translate(var(--cds-popover-offset,0),50%)}.cds--popover--right-top>.cds--popover .cds--popover-content{top:50%;right:100%;transform:translate(var(--cds-popover-offset,0),calc(-1*(.5 * var(--cds-popover-offset,0) * -1 - 16px)))}.cds--popover--right-bottom>.cds--popover .cds--popover-content{bottom:50%;right:100%;transform:translate(var(--cds-popover-offset,0),calc(-1*(.5 * var(--cds-popover-offset,0) + 16px)))}.cds--popover--right-bottom>.cds--popover .cds--popover-content::before,.cds--popover--right-top>.cds--popover .cds--popover-content::before,.cds--popover--right>.cds--popover .cds--popover-content::before{top:0;bottom:0;right:0;width:var(--cds-popover-offset,0);transform:translateX(100%)}.cds--popover--right-bottom>.cds--popover .cds--popover-caret,.cds--popover--right-top>.cds--popover .cds--popover-caret,.cds--popover--right>.cds--popover .cds--popover-caret{top:50%;right:100%;width:var(--cds-popover-caret-height,.375rem);height:var(--cds-popover-caret-width,.75rem);-webkit-clip-path:polygon(0 50%,100% 0,100% 100%);clip-path:polygon(0 50%,100% 0,100% 100%);transform:translate(calc(-1*(var(--cds-popover-offset,0) - 100%)),-50%)}.cds--popover--left>.cds--popover .cds--popover-content{top:50%;left:100%;transform:translate(calc(-1*(-1 * var(--cds-popover-offset,0) + .1px)),-50%)}.cds--popover--left-top>.cds--popover .cds--popover-content{top:-50%;left:100%;transform:translate(calc(-1*(-1 * var(--cds-popover-offset,0))),calc(-.5 * var(--cds-popover-offset,0) + 16px))}.cds--popover--left-bottom>.cds--popover .cds--popover-content{left:100%;bottom:-50%;transform:translate(calc(-1*(-1 * var(--cds-popover-offset,0))),calc(.5 * var(--cds-popover-offset,0) - 16px))}.cds--popover--left-bottom>.cds--popover .cds--popover-content::before,.cds--popover--left-top>.cds--popover .cds--popover-content::before,.cds--popover--left>.cds--popover .cds--popover-content::before{top:0;left:0;bottom:0;width:var(--cds-popover-offset,0);transform:translateX(-100%)}.cds--popover--left-bottom>.cds--popover .cds--popover-caret,.cds--popover--left-top>.cds--popover .cds--popover-caret,.cds--popover--left>.cds--popover .cds--popover-caret{top:50%;left:100%;width:var(--cds-popover-caret-height,.375rem);height:var(--cds-popover-caret-width,.75rem);-webkit-clip-path:polygon(0 0,100% 50%,0 100%);clip-path:polygon(0 0,100% 50%,0 100%);transform:translate(calc(-1*(-1 * var(--cds-popover-offset,0) + 100%)),-50%)}.cds--popover--tab-tip>.cds--popover .cds--popover-content{border-radius:0}.cds--popover--tab-tip .cds--popover{will-change:filter}.cds--popover--tab-tip__button{box-sizing:border-box;padding:0;border:0;margin:0;font-family:inherit;font-size:100%;vertical-align:baseline;display:inline-block;padding:0;border:0;-webkit-appearance:none;-moz-appearance:none;appearance:none;background:0 0;cursor:pointer;text-align:start;width:100%;position:relative;display:inline-flex;width:2rem;height:2rem;align-items:center;justify-content:center}.cds--popover--tab-tip__button *,.cds--popover--tab-tip__button ::after,.cds--popover--tab-tip__button ::before{box-sizing:inherit}.cds--popover--tab-tip__button::-moz-focus-inner{border:0}.cds--popover--tab-tip__button:focus{outline:2px solid var(--cds-focus,#0f62fe);outline-offset:-2px}@media screen and (prefers-contrast){.cds--popover--tab-tip__button:focus{outline-style:dotted}}.cds--popover--tab-tip__button:hover{background-color:var(--cds-layer-hover)}.cds--popover--tab-tip.cds--popover--open .cds--popover--tab-tip__button{background:var(--cds-layer);box-shadow:0 2px 2px rgba(0,0,0,.2)}.cds--popover--tab-tip.cds--popover--open .cds--popover--tab-tip__button:not(:focus)::after{position:absolute;z-index:6001;bottom:0;width:100%;height:2px;background:var(--cds-layer);content:\"\"}.cds--popover--tab-tip__button svg{fill:var(--cds-icon-primary,#161616)}.cds--tooltip{--cds-popover-offset:12px}.cds--tooltip-content{font-size:var(--cds-body-01-font-size,.875rem);font-weight:var(--cds-body-01-font-weight,400);line-height:var(--cds-body-01-line-height,1.42857);letter-spacing:var(--cds-body-01-letter-spacing,.16px);max-width:18rem;padding:var(--cds-tooltip-padding-block,1rem) var(--cds-tooltip-padding-inline,1rem);color:var(--cds-text-inverse,#fff)}.cds--icon-tooltip{--cds-tooltip-padding-block:0.125rem;--cds-popover-caret-width:0.5rem;--cds-popover-caret-height:0.25rem;--cds-popover-offset:0.5rem}.cds--icon-tooltip .cds--tooltip-content{font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);line-height:var(--cds-body-compact-01-line-height,1.28572);letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px)}.cds--definition-term{box-sizing:border-box;padding:0;border:0;margin:0;font-family:inherit;font-size:100%;vertical-align:baseline;display:inline-block;padding:0;border:0;-webkit-appearance:none;-moz-appearance:none;appearance:none;background:0 0;cursor:pointer;text-align:start;width:100%;border-bottom:1px dotted var(--cds-border-strong);border-radius:0;color:var(--cds-text-primary,#161616)}.cds--definition-term *,.cds--definition-term ::after,.cds--definition-term ::before{box-sizing:inherit}.cds--definition-term::-moz-focus-inner{border:0}.cds--definition-term:focus{outline:1px solid var(--cds-focus,#0f62fe);border-bottom-color:var(--cds-border-interactive,#0f62fe)}@media screen and (prefers-contrast){.cds--definition-term:focus{outline-style:dotted}}.cds--definition-term:hover{border-bottom-color:var(--cds-border-interactive,#0f62fe)}.cds--definition-tooltip{font-size:var(--cds-body-01-font-size,.875rem);font-weight:var(--cds-body-01-font-weight,400);line-height:var(--cds-body-01-line-height,1.42857);letter-spacing:var(--cds-body-01-letter-spacing,.16px);max-width:11rem;padding:.5rem 1rem}.cds--btn{--cds-layout-size-height-local:clamp(var(--cds-layout-size-height-min), var(--cds-layout-size-height, var(--cds-layout-size-height-lg)), var(--cds-layout-size-height-max));--cds-layout-density-padding-inline-local:clamp(var(--cds-layout-density-padding-inline-min), var(--cds-layout-density-padding-inline, var(--cds-layout-density-padding-inline-normal)), var(--cds-layout-density-padding-inline-max));--temp-1lh:(\n    var(--cds-body-compact-01-line-height, 1.28572) * 1em\n  );--temp-expressive-1lh:(\n    var(--cds-body-compact-02-line-height, 1.375) * 1em\n  );--temp-padding-block-max:calc(\n    (var(--cds-layout-size-height-lg) - var(--temp-1lh)) / 2 -\n      0.0625rem\n  );box-sizing:border-box;padding:0;border:0;margin:0;font-family:inherit;font-size:100%;vertical-align:baseline;font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);line-height:var(--cds-body-compact-01-line-height,1.28572);letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);position:relative;display:inline-flex;width:-moz-max-content;width:max-content;max-width:20rem;min-height:var(--cds-layout-size-height-local);flex-shrink:0;justify-content:space-between;margin:0;border-radius:0;cursor:pointer;outline:0;padding-block:min((var(--cds-layout-size-height-local) - var(--temp-1lh)) / 2 - .0625rem,var(--temp-padding-block-max));padding-inline-end:calc(var(--cds-layout-density-padding-inline-local) * 3 + 1rem - .0625rem);padding-inline-start:calc(var(--cds-layout-density-padding-inline-local) - .0625rem);text-align:right;text-decoration:none;transition:background 70ms cubic-bezier(0,0,.38,.9),box-shadow 70ms cubic-bezier(0,0,.38,.9),border-color 70ms cubic-bezier(0,0,.38,.9),outline 70ms cubic-bezier(0,0,.38,.9);vertical-align:top}.cds--btn *,.cds--btn ::after,.cds--btn ::before{box-sizing:inherit}.cds--btn.cds--btn--disabled,.cds--btn.cds--btn--disabled:focus,.cds--btn.cds--btn--disabled:hover,.cds--btn:disabled,.cds--btn:focus:disabled,.cds--btn:hover:disabled{border-color:var(--cds-button-disabled,#c6c6c6);background:var(--cds-button-disabled,#c6c6c6);box-shadow:none;color:var(--cds-text-on-color-disabled,#8d8d8d);cursor:not-allowed}.cds--btn .cds--btn__icon{position:absolute;top:min((var(--cds-layout-size-height-local) - 1rem) / 2 - .0625rem,var(--temp-padding-block-max));left:var(--cds-layout-density-padding-inline-local);width:1rem;height:1rem;flex-shrink:0;margin-block-start:.0625rem}.cds--btn::-moz-focus-inner{padding:0;border:0}.cds--btn--primary{border-width:1px;border-style:solid;border-color:transparent;background-color:var(--cds-button-primary,#0f62fe);color:var(--cds-text-on-color,#fff)}.cds--btn--primary:hover{background-color:var(--cds-button-primary-hover,#0050e6)}.cds--btn--primary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--primary:active{background-color:var(--cds-button-primary-active,#002d9c)}.cds--btn--primary .cds--btn__icon,.cds--btn--primary .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--primary:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--secondary{border-width:1px;border-style:solid;border-color:transparent;background-color:var(--cds-button-secondary,#393939);color:var(--cds-text-on-color,#fff)}.cds--btn--secondary:hover{background-color:var(--cds-button-secondary-hover,#474747)}.cds--btn--secondary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--secondary:active{background-color:var(--cds-button-secondary-active,#6f6f6f)}.cds--btn--secondary .cds--btn__icon,.cds--btn--secondary .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--secondary:focus,.cds--btn--secondary:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--tertiary{border-width:1px;border-style:solid;border-color:var(--cds-button-tertiary,#0f62fe);background-color:transparent;color:var(--cds-button-tertiary,#0f62fe)}.cds--btn--tertiary:hover{background-color:var(--cds-button-tertiary-hover,#0050e6)}.cds--btn--tertiary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--tertiary:active{background-color:var(--cds-button-tertiary-active,#002d9c)}.cds--btn--tertiary .cds--btn__icon,.cds--btn--tertiary .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--tertiary:hover{color:var(--cds-text-inverse,#fff)}.cds--btn--tertiary:focus{background-color:var(--cds-button-tertiary,#0f62fe);color:var(--cds-text-inverse,#fff)}.cds--btn--tertiary:active{border-color:transparent;background-color:var(--cds-button-tertiary-active,#002d9c);color:var(--cds-text-inverse,#fff)}.cds--btn--tertiary.cds--btn--disabled,.cds--btn--tertiary.cds--btn--disabled:focus,.cds--btn--tertiary.cds--btn--disabled:hover,.cds--btn--tertiary:disabled,.cds--btn--tertiary:focus:disabled,.cds--btn--tertiary:hover:disabled{background:0 0;color:var(--cds-text-on-color-disabled,#8d8d8d);outline:0}.cds--btn--ghost{border-width:1px;border-style:solid;border-color:transparent;background-color:transparent;color:var(--cds-link-primary,#0f62fe);padding-inline-end:calc(var(--cds-layout-density-padding-inline-local) - .0625rem)}.cds--btn--ghost:hover{background-color:var(--cds-layer-hover)}.cds--btn--ghost:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--ghost:active{background-color:var(--cds-layer-active)}.cds--btn--ghost .cds--btn__icon,.cds--btn--ghost .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--ghost .cds--btn__icon{position:static;margin-right:.5rem}.cds--btn--ghost:active,.cds--btn--ghost:hover{color:var(--cds-link-primary-hover,#0043ce)}.cds--btn--ghost:active{background-color:var(--cds-background-active,rgba(141,141,141,.5))}.cds--btn--ghost.cds--btn--disabled,.cds--btn--ghost.cds--btn--disabled:focus,.cds--btn--ghost.cds--btn--disabled:hover,.cds--btn--ghost:disabled,.cds--btn--ghost:focus:disabled,.cds--btn--ghost:hover:disabled{border-color:transparent;background:0 0;color:var(--cds-text-on-color-disabled,#8d8d8d);outline:0}.cds--btn--ghost:not([disabled]) svg{fill:var(--cds-icon-primary,#161616)}.cds--btn--icon-only{width:var(--cds-layout-size-height-local);height:var(--cds-layout-size-height-local);justify-content:center;padding:0;padding-block-start:min((var(--cds-layout-size-height-local) - 1rem) / 2 - .0625rem,var(--temp-padding-block-max))}.cds--btn--icon-only>:first-child{min-width:1rem;margin-block-start:.0625rem}.cds--btn--icon-only .cds--btn__icon{position:static}.cds--btn--icon-only.cds--btn--danger--ghost .cds--btn__icon,.cds--btn--icon-only.cds--btn--ghost .cds--btn__icon{margin:0}.cds--btn--icon-only.cds--btn--selected{background:var(--cds-background-selected,rgba(141,141,141,.2))}.cds--btn path[data-icon-path=inner-path]{fill:none}.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon,.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:var(--cds-icon-primary,#161616)}.cds--btn--ghost.cds--btn--icon-only[disabled] .cds--btn__icon,.cds--btn--ghost.cds--btn--icon-only[disabled] .cds--btn__icon path:not([data-icon-path]):not([fill=none]),.cds--btn.cds--btn--icon-only.cds--btn--ghost[disabled]:hover .cds--btn__icon{fill:var(--cds-icon-on-color-disabled,#8d8d8d)}.cds--btn--ghost.cds--btn--icon-only[disabled]{cursor:not-allowed}.cds--icon-tooltip--disabled .cds--tooltip-trigger__wrapper{cursor:not-allowed}.cds--icon-tooltip--disabled .cds--btn--icon-only[disabled]{pointer-events:none}.cds--btn--danger{border-width:1px;border-style:solid;border-color:transparent;background-color:var(--cds-button-danger-primary,#da1e28);color:var(--cds-text-on-color,#fff)}.cds--btn--danger:hover{background-color:var(--cds-button-danger-hover,#b81921)}.cds--btn--danger:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--danger:active{background-color:var(--cds-button-danger-active,#750e13)}.cds--btn--danger .cds--btn__icon,.cds--btn--danger .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--danger:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary{border-width:1px;border-style:solid;border-color:var(--cds-button-danger-secondary,#da1e28);background-color:transparent;color:var(--cds-button-danger-secondary,#da1e28)}.cds--btn--danger--tertiary:hover{background-color:var(--cds-button-danger-hover,#b81921)}.cds--btn--danger--tertiary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--danger--tertiary:active{background-color:var(--cds-button-danger-active,#750e13)}.cds--btn--danger--tertiary .cds--btn__icon,.cds--btn--danger--tertiary .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--danger--tertiary:hover{border-color:var(--cds-button-danger-hover,#b81921);color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary:focus{background-color:var(--cds-button-danger-primary,#da1e28);color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary:active{border-color:var(--cds-button-danger-active,#750e13);background-color:var(--cds-button-danger-active,#750e13);color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary.cds--btn--disabled,.cds--btn--danger--tertiary.cds--btn--disabled:focus,.cds--btn--danger--tertiary.cds--btn--disabled:hover,.cds--btn--danger--tertiary:disabled,.cds--btn--danger--tertiary:focus:disabled,.cds--btn--danger--tertiary:hover:disabled{background:0 0;color:var(--cds-text-on-color-disabled,#8d8d8d);outline:0}.cds--btn--danger--ghost{border-width:1px;border-style:solid;border-color:transparent;background-color:transparent;color:var(--cds-button-danger-secondary,#da1e28);padding-inline-end:calc(var(--cds-layout-density-padding-inline-local) - .0625rem)}.cds--btn--danger--ghost:hover{background-color:var(--cds-button-danger-hover,#b81921)}.cds--btn--danger--ghost:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--danger--ghost:active{background-color:var(--cds-button-danger-active,#750e13)}.cds--btn--danger--ghost .cds--btn__icon,.cds--btn--danger--ghost .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--danger--ghost .cds--btn__icon{position:static;margin-right:.5rem}.cds--btn--danger--ghost:active,.cds--btn--danger--ghost:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--danger--ghost.cds--btn--disabled,.cds--btn--danger--ghost.cds--btn--disabled:focus,.cds--btn--danger--ghost.cds--btn--disabled:hover,.cds--btn--danger--ghost:disabled,.cds--btn--danger--ghost:focus:disabled,.cds--btn--danger--ghost:hover:disabled{border-color:transparent;background:0 0;color:var(--cds-text-disabled,rgba(22,22,22,.25));outline:0}.cds--btn--expressive{font-size:var(--cds-body-compact-02-font-size,1rem);font-weight:var(--cds-body-compact-02-font-weight,400);line-height:var(--cds-body-compact-02-line-height,1.375);letter-spacing:var(--cds-body-compact-02-letter-spacing,0);padding-block:min((var(--cds-layout-size-height-local) - var(--temp-expressive-1lh)) / 2 - .0625rem,var(--temp-padding-block-max))}.cds--btn--icon-only.cds--btn--expressive{padding:12px 13px}.cds--btn.cds--btn--expressive .cds--btn__icon{width:1.25rem;height:1.25rem}.cds--btn-set .cds--btn.cds--btn--expressive{max-width:20rem}.cds--btn.cds--skeleton{position:relative;padding:0;border:none;background:var(--cds-skeleton-background,#e8e8e8);box-shadow:none;pointer-events:none;width:9.375rem}.cds--btn.cds--skeleton:active,.cds--btn.cds--skeleton:focus,.cds--btn.cds--skeleton:hover{border:none;cursor:default;outline:0}.cds--btn.cds--skeleton::before{position:absolute;width:100%;height:100%;animation:3s ease-in-out skeleton infinite;background:var(--cds-skeleton-element,#c6c6c6);content:\"\";will-change:transform-origin,transform,opacity}@media (prefers-reduced-motion:reduce){.cds--btn.cds--skeleton::before{animation:none}}.cds--btn-set{display:flex}.cds--btn-set--stacked{flex-direction:column}.cds--btn-set .cds--btn{width:100%;max-width:12.25rem}.cds--btn-set .cds--btn:not(:focus){box-shadow:.0625rem 0 0 0 var(--cds-button-separator,#e0e0e0)}.cds--btn-set .cds--btn:first-of-type:not(:focus){box-shadow:inherit}.cds--btn-set .cds--btn:focus+.cds--btn{box-shadow:inherit}.cds--btn-set--stacked .cds--btn:not(:focus){box-shadow:0 -.0625rem 0 0 var(--cds-button-separator,#e0e0e0)}.cds--btn-set--stacked .cds--btn:first-of-type:not(:focus){box-shadow:inherit}.cds--btn-set .cds--btn.cds--btn--disabled{box-shadow:.0625rem 0 0 0 var(--cds-icon-on-color-disabled,#8d8d8d)}.cds--btn-set .cds--btn.cds--btn--disabled:first-of-type{box-shadow:none}.cds--btn-set--stacked .cds--btn.cds--btn--disabled{box-shadow:0 -.0625rem 0 0 var(--cds-layer-selected-disabled,#8d8d8d)}.cds--btn-set--stacked .cds--btn.cds--btn--disabled:first-of-type{box-shadow:none}@media screen and (-ms-high-contrast:active),(forced-colors:active){.cds--btn:focus{color:Highlight;outline:1px solid Highlight}}@media screen and (-ms-high-contrast:active),(forced-colors:active){.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon,.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:ButtonText}}input:-webkit-autofill,input:-webkit-autofill:focus,input:-webkit-autofill:hover,textarea:-webkit-autofill,textarea:-webkit-autofill:focus,textarea:-webkit-autofill:hover{box-shadow:0 0 0 1000px var(--cds-field) inset;-webkit-text-fill-color:var(--cds-text-primary,#161616)}.cds--fieldset{box-sizing:border-box;padding:0;border:0;margin:0;font-family:inherit;font-size:100%;vertical-align:baseline}.cds--fieldset *,.cds--fieldset ::after,.cds--fieldset ::before{box-sizing:inherit}.cds--form-item,:host(cds-file-uploader-shell){font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);line-height:var(--cds-body-compact-01-line-height,1.28572);letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);display:flex;flex:1 1 auto;flex-direction:column;align-items:flex-start}.cds--label{font-size:var(--cds-label-01-font-size,.75rem);font-weight:var(--cds-label-01-font-weight,400);line-height:var(--cds-label-01-line-height,1.33333);letter-spacing:var(--cds-label-01-letter-spacing,.32px);display:inline-block;margin-bottom:.5rem;color:var(--cds-text-secondary,#525252);font-weight:400;line-height:1rem;vertical-align:baseline}.cds--label html{font-size:100%}.cds--label body{font-weight:400;font-family:'IBM Plex Sans',system-ui,-apple-system,BlinkMacSystemFont,'.SFNSText-Regular',sans-serif;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;text-rendering:optimizeLegibility}.cds--label code{font-family:'IBM Plex Mono',system-ui,-apple-system,BlinkMacSystemFont,'.SFNSText-Regular',monospace}.cds--label strong{font-weight:600}.cds--label .cds--toggletip-label{font-size:var(--cds-label-01-font-size,.75rem);font-weight:var(--cds-label-01-font-weight,400);line-height:var(--cds-label-01-line-height,1.33333);letter-spacing:var(--cds-label-01-letter-spacing,.32px)}.cds--label--no-margin{margin-bottom:0}.cds--label+.cds--tooltip{position:relative;top:.2rem;right:.5rem}.cds--label+.cds--tooltip .cds--tooltip__trigger{box-sizing:border-box;padding:0;border:0;margin:0;font-family:inherit;font-size:100%;vertical-align:baseline;display:inline-block;padding:0;border:0;-webkit-appearance:none;-moz-appearance:none;appearance:none;background:0 0;cursor:pointer;text-align:start;width:100%;display:flex;align-items:center;justify-content:center;font-size:var(--cds-label-01-font-size,.75rem);font-weight:var(--cds-label-01-font-weight,400);line-height:var(--cds-label-01-line-height,1.33333);letter-spacing:var(--cds-label-01-letter-spacing,.32px)}.cds--label+.cds--tooltip .cds--tooltip__trigger *,.cds--label+.cds--tooltip .cds--tooltip__trigger ::after,.cds--label+.cds--tooltip .cds--tooltip__trigger ::before{box-sizing:inherit}.cds--label+.cds--tooltip .cds--tooltip__trigger::-moz-focus-inner{border:0}.cds--label+.cds--tooltip .cds--tooltip__trigger:focus{outline:1px solid var(--cds-focus,#0f62fe)}.cds--label+.cds--tooltip .cds--tooltip__trigger svg{fill:var(--cds-icon-secondary,#525252)}.cds--label+.cds--tooltip .cds--tooltip__trigger svg :hover{fill:var(--cds-icon-primary,#161616)}.cds--label+.cds--toggletip{top:.2rem;right:.5rem}.cds--label.cds--skeleton{position:relative;padding:0;border:none;background:var(--cds-skeleton-background,#e8e8e8);box-shadow:none;pointer-events:none;width:4.6875rem;height:.875rem}.cds--label.cds--skeleton:active,.cds--label.cds--skeleton:focus,.cds--label.cds--skeleton:hover{border:none;cursor:default;outline:0}.cds--label.cds--skeleton::before{position:absolute;width:100%;height:100%;animation:3s ease-in-out skeleton infinite;background:var(--cds-skeleton-element,#c6c6c6);content:\"\";will-change:transform-origin,transform,opacity}@media (prefers-reduced-motion:reduce){.cds--label.cds--skeleton::before{animation:none}}input[type=number]{font-family:'IBM Plex Sans',system-ui,-apple-system,BlinkMacSystemFont,'.SFNSText-Regular',sans-serif}.cds--combo-box[data-invalid]:not(.cds--multi-select--selected) .cds--text-input:not(:focus),.cds--list-box[data-invalid]:not(.cds--multi-select--invalid--focused),.cds--number[data-invalid] input[type=number]:not(:focus),.cds--select-input__wrapper[data-invalid] .cds--select-input:not(:focus),.cds--text-area__wrapper[data-invalid]>.cds--text-area--invalid:not(:focus),.cds--text-input__field-wrapper[data-invalid]>.cds--text-input--invalid:not(:focus),input[data-invalid]:not(:focus){outline:2px solid var(--cds-support-error,#da1e28);outline-offset:-2px}@media screen and (prefers-contrast){.cds--combo-box[data-invalid]:not(.cds--multi-select--selected) .cds--text-input:not(:focus),.cds--list-box[data-invalid]:not(.cds--multi-select--invalid--focused),.cds--number[data-invalid] input[type=number]:not(:focus),.cds--select-input__wrapper[data-invalid] .cds--select-input:not(:focus),.cds--text-area__wrapper[data-invalid]>.cds--text-area--invalid:not(:focus),.cds--text-input__field-wrapper[data-invalid]>.cds--text-input--invalid:not(:focus),input[data-invalid]:not(:focus){outline-style:dotted}}.cds--date-picker-input__wrapper--invalid~.cds--form-requirement,.cds--date-picker-input__wrapper--warn~.cds--form-requirement,.cds--date-picker-input__wrapper~.cds--form-requirement,.cds--list-box--warning~.cds--form-requirement,.cds--list-box[data-invalid]~.cds--form-requirement,.cds--number[data-invalid] .cds--number__input-wrapper~.cds--form-requirement,.cds--number__input-wrapper--warning~.cds--form-requirement,.cds--select--warning .cds--select-input__wrapper~.cds--form-requirement,.cds--select-input__wrapper[data-invalid]~.cds--form-requirement,.cds--text-area__wrapper--warn~.cds--form-requirement,.cds--text-area__wrapper[data-invalid]~.cds--form-requirement,.cds--text-input__field-wrapper--warning>.cds--text-input~.cds--form-requirement,.cds--text-input__field-wrapper--warning~.cds--form-requirement,.cds--text-input__field-wrapper[data-invalid]~.cds--form-requirement,.cds--time-picker--invalid~.cds--form-requirement,.cds--time-picker--warning~.cds--form-requirement,.cds--time-picker[data-invalid]~.cds--form-requirement,input[data-invalid]~.cds--form-requirement{display:block;overflow:visible;max-height:12.5rem;font-weight:400}.cds--date-picker-input__wrapper--invalid~.cds--form-requirement,.cds--date-picker-input__wrapper~.cds--form-requirement,.cds--list-box[data-invalid]~.cds--form-requirement,.cds--number[data-invalid] .cds--number__input-wrapper~.cds--form-requirement,.cds--select-input__wrapper[data-invalid]~.cds--form-requirement,.cds--text-area__wrapper[data-invalid]~.cds--form-requirement,.cds--text-input__field-wrapper[data-invalid]~.cds--form-requirement,.cds--time-picker--invalid~.cds--form-requirement,.cds--time-picker[data-invalid]~.cds--form-requirement,input[data-invalid]~.cds--form-requirement{color:var(--cds-text-error,#da1e28)}.cds--form--fluid .cds--text-input__field-wrapper--warning,.cds--form--fluid .cds--text-input__field-wrapper[data-invalid]{display:block}.cds--form--fluid input[data-invalid]{outline:0}.cds--form--fluid .cds--form-requirement{padding:.5rem 1rem .5rem 2.5rem;margin:0}input:not(output):not([data-invalid]):-moz-ui-invalid{box-shadow:none}.cds--form-requirement{font-size:var(--cds-label-01-font-size,.75rem);font-weight:var(--cds-label-01-font-weight,400);line-height:var(--cds-label-01-line-height,1.33333);letter-spacing:var(--cds-label-01-letter-spacing,.32px);display:none;overflow:hidden;max-height:0;margin:.25rem 0 0}.cds--form-requirement html{font-size:100%}.cds--form-requirement body{font-weight:400;font-family:'IBM Plex Sans',system-ui,-apple-system,BlinkMacSystemFont,'.SFNSText-Regular',sans-serif;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;text-rendering:optimizeLegibility}.cds--form-requirement code{font-family:'IBM Plex Mono',system-ui,-apple-system,BlinkMacSystemFont,'.SFNSText-Regular',monospace}.cds--form-requirement strong{font-weight:600}.cds--select--inline .cds--form__helper-text{margin-top:0}.cds--form__helper-text{font-size:var(--cds-helper-text-01-font-size,.75rem);line-height:var(--cds-helper-text-01-line-height,1.33333);letter-spacing:var(--cds-helper-text-01-letter-spacing,.32px);z-index:0;width:100%;margin-top:.25rem;color:var(--cds-text-secondary,#525252);opacity:1}.cds--form__helper-text--disabled,.cds--label--disabled{color:var(--cds-text-disabled,rgba(22,22,22,.25))}fieldset[disabled] .cds--form__helper-text,fieldset[disabled] .cds--label{color:var(--cds-text-disabled,rgba(22,22,22,.25))}.cds--loading{box-sizing:border-box;padding:0;border:0;margin:0;font-family:inherit;font-size:100%;vertical-align:baseline;animation-duration:690ms;animation-fill-mode:forwards;animation-iteration-count:infinite;animation-name:rotate;animation-timing-function:linear;width:5.5rem;height:5.5rem}.cds--loading *,.cds--loading ::after,.cds--loading ::before{box-sizing:inherit}.cds--loading svg circle{animation-duration:10ms;animation-name:init-stroke;animation-timing-function:cubic-bezier(.5,0,.1,1)}@media screen and (prefers-reduced-motion:reduce){.cds--loading svg circle{animation:none}}.cds--loading__svg{fill:transparent}.cds--loading__svg circle{stroke-dasharray:276.4608 276.4608;stroke-linecap:butt;stroke-width:10}.cds--loading__stroke{stroke:var(--cds-interactive,#0f62fe);stroke-dashoffset:52.527552}.cds--loading--small .cds--loading__stroke{stroke-dashoffset:143.759616}.cds--loading--stop{animation:rotate-end-p1 .7s cubic-bezier(0,0,.25,1) forwards,rotate-end-p2 .7s cubic-bezier(0,0,.25,1) .7s forwards}.cds--loading--stop svg circle{animation-delay:.7s;animation-duration:.7s;animation-fill-mode:forwards;animation-name:stroke-end;animation-timing-function:cubic-bezier(0,0,.25,1)}@media screen and (prefers-reduced-motion:reduce){.cds--loading--stop svg circle{animation:none}}.cds--loading--small{width:1rem;height:1rem}.cds--loading--small circle{stroke-width:16}.cds--loading--small .cds--loading__svg{stroke:var(--cds-interactive,#0f62fe)}.cds--loading__background{stroke:var(--cds-layer-accent);stroke-dashoffset:-22}@media not all and (min-resolution:0.001dpcm){@supports (-webkit-appearance:none) and (stroke-color:transparent){circle.cds--loading__background{stroke-dasharray:265;stroke-dashoffset:0}}}.cds--loading-overlay{position:fixed;z-index:6000;top:0;right:0;display:flex;width:100%;height:100%;align-items:center;justify-content:center;background-color:var(--cds-overlay,rgba(22,22,22,.5));transition:background-color .7s cubic-bezier(.4,.14,.3,1)}.cds--loading-overlay--stop{display:none}@keyframes rotate{0%{transform:rotate(0)}100%{transform:rotate(-360deg)}}@keyframes rotate-end-p1{100%{transform:rotate(-360deg)}}@keyframes rotate-end-p2{100%{transform:rotate(360deg)}}@keyframes init-stroke{0%{stroke-dashoffset:276.4608}100%{stroke-dashoffset:52.527552}}@keyframes stroke-end{0%{stroke-dashoffset:52.527552}100%{stroke-dashoffset:276.4608}}.cds--file,:host(cds-file-drop-container){width:100%}.cds--file--invalid{margin-left:.5rem;fill:var(--cds-support-error,#da1e28)}.cds--file--label{font-size:var(--cds-heading-compact-01-font-size,.875rem);font-weight:var(--cds-heading-compact-01-font-weight,600);line-height:var(--cds-heading-compact-01-line-height,1.28572);letter-spacing:var(--cds-heading-compact-01-letter-spacing,.16px);margin-bottom:.5rem;color:var(--cds-text-primary,#161616)}.cds--file--label html{font-size:100%}.cds--file--label body{font-weight:400;font-family:'IBM Plex Sans',system-ui,-apple-system,BlinkMacSystemFont,'.SFNSText-Regular',sans-serif;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;text-rendering:optimizeLegibility}.cds--file--label code{font-family:'IBM Plex Mono',system-ui,-apple-system,BlinkMacSystemFont,'.SFNSText-Regular',monospace}.cds--file--label strong{font-weight:600}.cds--file--label--disabled{color:var(--cds-text-disabled,rgba(22,22,22,.25))}.cds--file-input{position:absolute;overflow:hidden;width:1px;height:1px;padding:0;border:0;margin:-1px;clip:rect(0,0,0,0);visibility:inherit;white-space:nowrap}.cds--file-btn{display:inline-flex;padding-left:4rem;margin:0}.cds--file-browse-btn{display:inline-block;width:100%;max-width:20rem;color:var(--cds-link-primary,#0f62fe);cursor:pointer;outline:2px solid transparent;outline-offset:-2px;transition:110ms cubic-bezier(.2,0,.38,.9)}.cds--file-browse-btn:focus,.cds--file-browse-btn:hover{outline:2px solid var(--cds-focus,#0f62fe)}.cds--file-browse-btn:active,.cds--file-browse-btn:active:visited,.cds--file-browse-btn:focus,.cds--file-browse-btn:hover{text-decoration:underline}.cds--file-browse-btn:active{color:var(--cds-text-primary,#161616)}.cds--file-browse-btn--disabled{color:var(--cds-text-disabled,rgba(22,22,22,.25));cursor:no-drop;text-decoration:none}.cds--file-browse-btn--disabled:focus,.cds--file-browse-btn--disabled:hover{color:var(--cds-text-disabled,rgba(22,22,22,.25));outline:0;text-decoration:none}.cds--file-browse-btn--disabled .cds--file__drop-container{border:1px dashed var(--cds-button-disabled,#c6c6c6)}.cds--label-description{font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);line-height:var(--cds-body-compact-01-line-height,1.28572);letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);margin-bottom:1rem;color:var(--cds-text-secondary,#525252)}.cds--label-description html{font-size:100%}.cds--label-description body{font-weight:400;font-family:'IBM Plex Sans',system-ui,-apple-system,BlinkMacSystemFont,'.SFNSText-Regular',sans-serif;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;text-rendering:optimizeLegibility}.cds--label-description code{font-family:'IBM Plex Mono',system-ui,-apple-system,BlinkMacSystemFont,'.SFNSText-Regular',monospace}.cds--label-description strong{font-weight:600}.cds--label-description--disabled{color:var(--cds-text-disabled,rgba(22,22,22,.25))}.cds--file-container--drop{width:100%}.cds--file-btn~.cds--file-container{margin-top:1.5rem}.cds--btn~.cds--file-container{margin-top:1rem}.cds--file .cds--file-container,.cds--file~.cds--file-container,:host(cds-file-drop-container) .cds--file-container,:host(cds-file-drop-container)~.cds--file-container{margin-top:.5rem}.cds--file__selected-file,:host(cds-file-uploader-item){display:grid;max-width:20rem;min-height:3rem;align-items:center;margin-bottom:.5rem;background-color:var(--cds-layer);gap:.75rem 1rem;grid-auto-rows:auto;grid-template-columns:1fr auto;word-break:break-word}.cds--file__selected-file:last-child{margin-bottom:0}.cds--file__selected-file .cds--form-requirement,:host(cds-file-uploader-item) .cds--form-requirement{display:block;max-height:none;margin:0;grid-column:1/-1}.cds--file__selected-file .cds--inline-loading__animation .cds--loading,:host(cds-file-uploader-item) .cds--inline-loading__animation .cds--loading{margin-left:0}.cds--file__selected-file .cds--file-filename,:host(cds-file-uploader-item) .cds--file-filename{font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);line-height:var(--cds-body-compact-01-line-height,1.28572);letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);overflow:hidden;margin-right:1rem;text-overflow:ellipsis;white-space:nowrap}.cds--file__selected-file--md,:host(cds-file-uploader-item[size=md]){min-height:2.5rem;gap:.5rem 1rem}.cds--file__selected-file--sm,:host(cds-file-uploader-item[size=sm]){min-height:2rem;gap:.25rem 1rem}.cds--file__selected-file--invalid__wrapper{outline:2px solid var(--cds-support-error,#da1e28);outline-offset:-2px;max-width:20rem;margin-bottom:.5rem;background-color:var(--cds-layer);outline-width:1px}@media screen and (prefers-contrast){.cds--file__selected-file--invalid__wrapper{outline-style:dotted}}.cds--file__selected-file--invalid,:host(cds-file-uploader-item[invalid]){outline:2px solid var(--cds-support-error,#da1e28);outline-offset:-2px;padding:.75rem 0}@media screen and (prefers-contrast){.cds--file__selected-file--invalid,:host(cds-file-uploader-item[invalid]){outline-style:dotted}}.cds--file__selected-file--invalid.cds--file__selected-file--sm{padding:.25rem 0}.cds--file__selected-file--invalid.cds--file__selected-file--md{padding:.5rem 0}.cds--file__selected-file--invalid .cds--form-requirement,:host(cds-file-uploader-item[invalid]) .cds--form-requirement{padding-top:1rem;border-top:1px solid var(--cds-border-subtle)}.cds--file__selected-file--invalid.cds--file__selected-file--sm .cds--form-requirement{padding-top:.4375rem}.cds--file__selected-file--invalid.cds--file__selected-file--md .cds--form-requirement{padding-top:.6875rem}.cds--file__selected-file--invalid .cds--form-requirement__supplement,.cds--file__selected-file--invalid .cds--form-requirement__title,:host(cds-file-uploader-item[invalid]) .cds--form-requirement__supplement,:host(cds-file-uploader-item[invalid]) .cds--form-requirement__title{font-size:var(--cds-label-01-font-size,.75rem);font-weight:var(--cds-label-01-font-weight,400);line-height:var(--cds-label-01-line-height,1.33333);letter-spacing:var(--cds-label-01-letter-spacing,.32px);padding:0 1rem}.cds--file__selected-file--invalid .cds--form-requirement__title,:host(cds-file-uploader-item[invalid]) .cds--form-requirement__title{color:var(--cds-text-error,#da1e28)}.cds--file__selected-file--invalid .cds--form-requirement__supplement,:host(cds-file-uploader-item[invalid]) .cds--form-requirement__supplement{color:var(--cds-text-primary,#161616)}.cds--file__selected-file--invalid+.cds--form-requirement,:host(cds-file-uploader-item[invalid])+.cds--form-requirement{font-size:var(--cds-label-01-font-size,.75rem);font-weight:var(--cds-label-01-font-weight,400);line-height:var(--cds-label-01-line-height,1.33333);letter-spacing:var(--cds-label-01-letter-spacing,.32px);display:block;overflow:visible;max-height:12.5rem;padding:.5rem 1rem;color:var(--cds-text-error,#da1e28);font-weight:400}.cds--file__selected-file--invalid+.cds--form-requirement .cds--form-requirement__supplement,:host(cds-file-uploader-item[invalid])+.cds--form-requirement .cds--form-requirement__supplement{padding-bottom:.5rem;color:var(--cds-text-primary,#161616)}.cds--file__state-container{display:flex;min-width:1.5rem;align-items:center;justify-content:center;padding-left:1rem}.cds--file__state-container .cds--loading__svg{stroke:var(--cds-icon-primary,#161616)}.cds--file__state-container .cds--file-complete{fill:var(--cds-interactive,#0f62fe)}.cds--file__state-container .cds--file-complete:focus{outline:1px solid var(--cds-focus,#0f62fe)}@media screen and (prefers-contrast){.cds--file__state-container .cds--file-complete:focus{outline-style:dotted}}.cds--file__state-container .cds--file-complete [data-icon-path=inner-path]{fill:var(--cds-icon-inverse,#fff);opacity:1}.cds--file__state-container .cds--file-invalid{width:1rem;height:1rem;fill:var(--cds-support-error,#da1e28)}.cds--file__state-container .cds--file-close{display:flex;width:1.5rem;height:1.5rem;align-items:center;justify-content:center;padding:0;border:none;background-color:transparent;cursor:pointer;fill:var(--cds-icon-primary,#161616)}.cds--file__state-container .cds--file-close:focus{outline:2px solid var(--cds-focus,#0f62fe);outline-offset:-2px}@media screen and (prefers-contrast){.cds--file__state-container .cds--file-close:focus{outline-style:dotted}}.cds--file__state-container .cds--file-close svg path{fill:var(--cds-icon-primary,#161616)}.cds--file__state-container .cds--inline-loading__animation{margin-left:-.5rem}.cds--file__drop-container{box-sizing:border-box;padding:0;border:0;margin:0;font-family:inherit;font-size:100%;vertical-align:baseline;display:inline-block;padding:0;border:0;-webkit-appearance:none;-moz-appearance:none;appearance:none;background:0 0;cursor:pointer;text-align:start;width:100%;display:flex;overflow:hidden;height:6rem;align-items:flex-start;justify-content:space-between;padding:1rem;border:1px dashed var(--cds-border-strong);font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);line-height:var(--cds-body-compact-01-line-height,1.28572);letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px)}.cds--file__drop-container *,.cds--file__drop-container ::after,.cds--file__drop-container ::before{box-sizing:inherit}.cds--file__drop-container::-moz-focus-inner{border:0}.cds--file__drop-container--drag-over{background:0 0;outline:2px solid var(--cds-focus,#0f62fe);outline-offset:-2px}@media screen and (-ms-high-contrast:active),(forced-colors:active){.cds--file__selected-file,:host(cds-file-uploader-item){outline:1px solid transparent}}@media screen and (-ms-high-contrast:active),(forced-colors:active){.cds--file__state-container .cds--file-close svg path{fill:ButtonText}}:host(cds-file-uploader-shell){align-items:stretch}:host(cds-file-uploader-item) .cds--file-filename{margin-top:0;margin-bottom:0}:host(cds-file-uploader-item) .cds--form-requirement[hidden]{display:none}:host(cds-file-uploader-item[invalid]) .cds--form-requirement__supplement{margin:0}:host(cds-file-uploader){--cds-layout-size-height-xs:1.5rem;--cds-layout-size-height-sm:2rem;--cds-layout-size-height-md:2.5rem;--cds-layout-size-height-lg:3rem;--cds-layout-size-height-xl:4rem;--cds-layout-size-height-2xl:5rem;--cds-layout-size-height-min:0px;--cds-layout-size-height-max:999999999px;--cds-layout-density-padding-inline-condensed:0.5rem;--cds-layout-density-padding-inline-normal:1rem;--cds-layout-density-padding-inline-min:0px;--cds-layout-density-padding-inline-max:999999999px}:host(cds-file-uploader) .cds--file--label,:host(cds-file-uploader) .cds--label-description{margin-top:0}:host(cds-file-uploader) .cds--file-container{margin-top:.5rem}",
]);
