/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * The alignment choices of popover.
 */
export declare enum POPOVER_ALIGNMENT {
    /**
     * Align the top position for the popover content.
     */
    TOP = "top",
    /**
     * Align the top-left position for the popover content.
     */
    TOP_LEFT = "top-left",
    /**
     * Align the top right position for the popover content.
     */
    TOP_RIGHT = "top-right",
    /**
     * Align the bottom position for the popover content.
     */
    BOTTOM = "bottom",
    /**
     * Align the bottom left position for the popover content.
     */
    BOTTOM_LEFT = "bottom-left",
    /**
     * Align the bottom right position for the popover content.
     */
    BOTTOM_RIGHT = "bottom-right",
    /**
     * Align the left position for the popover content.
     */
    LEFT = "left",
    /**
     * Align the left bottom position for the popover content.
     */
    LEFT_BOTTOM = "left-bottom",
    /**
     * Align the left top position for the popover content.
     */
    LEFT_TOP = "left-top",
    /**
     * Align the right position for the popover content.
     */
    RIGHT = "right",
    /**
     * Align the right bottom position for the popover content.
     */
    RIGHT_BOTTOM = "right-bottom",
    /**
     * Align the right top position for the popover content.
     */
    RIGHT_TOP = "right-top"
}

//# sourceMappingURL=defs.d.ts.map
