import _decorate from "@babel/runtime/helpers/esm/decorate";
/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { classMap } from 'lit/directives/class-map.js';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings';
import CDSLink from '../link/link';
import { TILE_COLOR_SCHEME } from './defs';
import styles from "././tile.css.js";
import { carbonElement as customElement } from '../../globals/decorators/carbon-element';

/**
 * Clickable tile.
 *
 * @element cds-clickable-tile
 */
let CDSClickableTile = _decorate([customElement(`${prefix}-clickable-tile`)], function (_initialize, _CDSLink) {
  class CDSClickableTile extends _CDSLink {
    constructor(...args) {
      super(...args);
      _initialize(this);
    }
  }
  return {
    F: CDSClickableTile,
    d: [{
      kind: "get",
      key: "_classes",
      value: function _classes() {
        const {
          colorScheme,
          disabled
        } = this;
        return classMap({
          [`${prefix}--link`]: true,
          [`${prefix}--link--disabled`]: disabled,
          [`${prefix}--tile`]: true,
          [`${prefix}--tile--clickable`]: true,
          [`${prefix}--tile--${colorScheme}`]: colorScheme
        });
      }

      /**
       * The color scheme.
       */
    }, {
      kind: "field",
      decorators: [property({
        attribute: 'color-scheme',
        reflect: true
      })],
      key: "colorScheme",
      value() {
        return TILE_COLOR_SCHEME.REGULAR;
      }
    }, {
      kind: "field",
      decorators: [property({
        attribute: 'link-role'
      })],
      key: "linkRole",
      value() {
        return 'button';
      }
    }, {
      kind: "field",
      static: true,
      key: "styles",
      value() {
        return styles;
      }
    }]
  };
}, CDSLink);
export default CDSClickableTile;
//# sourceMappingURL=clickable-tile.js.map
