/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { LitElement } from 'lit';
import { TILE_COLOR_SCHEME } from './defs';
export { TILE_COLOR_SCHEME };
/**
 * Basic tile.
 *
 * @element cds-tile
 */
declare class CDSTile extends LitElement {
    /**
     * The color scheme.
     */
    colorScheme: TILE_COLOR_SCHEME;
    updated(): void;
    render(): import("lit-html").TemplateResult<1>;
    static styles: any;
}
export default CDSTile;

//# sourceMappingURL=tile.d.ts.map
