import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _decorate from "@babel/runtime/helpers/esm/decorate";
let _ = t => t,
  _t;
/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { classMap } from 'lit/directives/class-map.js';
import { html, LitElement } from 'lit';
import { customElement, property } from 'lit/decorators.js';
import Information16 from "../../icons/information/16";
import { prefix } from '../../globals/settings';
import FocusMixin from '../../globals/mixins/focus';
import { POPOVER_ALIGNMENT } from '../popover/defs';
import styles from "././toggletip.css.js";

/**
 * Definition tooltip.
 *
 * @element cds-toggletip
 */ /**
     * Definition tooltip.
     *
     * @element cds-toggletip
     */
let CDSToggletip = _decorate([customElement(`${prefix}-toggletip`)], function (_initialize, _FocusMixin) {
  class CDSToggletip extends _FocusMixin {
    constructor(...args) {
      super(...args);
      _initialize(this);
    }
  }
  return {
    F: CDSToggletip,
    d: [{
      kind: "field",
      decorators: [property()],
      key: "alignment",
      value() {
        return POPOVER_ALIGNMENT.TOP;
      }
    }, {
      kind: "field",
      decorators: [property({
        type: Boolean,
        reflect: true
      })],
      key: "open",
      value() {
        return false;
      }
    }, {
      kind: "field",
      key: "_handleClick",
      value() {
        return () => {
          this.open = !this.open;
        };
      }
    }, {
      kind: "method",
      key: "render",
      value:
      /**
       * How the tooltip is aligned to the trigger button.
       */

      function render() {
        const {
          alignment,
          id,
          open
        } = this;
        const classes = classMap({
          [`${prefix}--popover-container`]: true,
          [`${prefix}--popover--caret`]: true,
          [`${prefix}--popover--high-contrast`]: true,
          [`${prefix}--popover--open`]: open,
          [`${prefix}--popover--${alignment}`]: alignment,
          [`${prefix}--toggletip`]: true,
          [`${prefix}--toggletip--open`]: open
        });
        return html(_t || (_t = _`
      <span class="${0}--toggletip-label">
        <slot></slot>
      </span>
      <span class="${0}">
        <button aria-controls="${0}" class="${0}--toggletip-button" @click=${0}>
          ${0}
        </button>

        <span class="${0}--popover">
          <span class="${0}--popover-content">

            <div class="${0}--toggletip-content">
              <slot name="body-text"></slot>
              <div class="${0}--toggletip-actions">
                <slot name="actions"></slot>
              </div>
            </div>
          </span>

        </span>
        <span class="${0}--popover-caret"></span>
      </span>
    </span>
    `), prefix, classes, id, prefix, this._handleClick, Information16({
          id: 'trigger'
        }), prefix, prefix, prefix, prefix, prefix);
      }
    }, {
      kind: "field",
      static: true,
      key: "shadowRootOptions",
      value() {
        return _objectSpread(_objectSpread({}, LitElement.shadowRootOptions), {}, {
          delegatesFocus: true
        });
      }
    }, {
      kind: "field",
      static: true,
      key: "styles",
      value() {
        return styles;
      }
    }]
  };
}, FocusMixin(LitElement));
export default CDSToggletip;
//# sourceMappingURL=toggletip.js.map
