/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { svg } from 'lit';
import spread from '../../globals/directives/spread';
const svgResultCarbonIcon = ({ children, ...attrs } = {}) =>
  svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(
    attrs
  )}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<switch ><g ><path d="M28 13H30V15H28z"></path><path d="M24.2 3.8H26.2V5.8H24.2z" transform="rotate(-45.001 25.192 4.808)"></path><path d="M15 0H17V2H15z"></path><path d="M5.8 3.8H7.8V5.8H5.8z" transform="rotate(-134.999 6.808 4.808)"></path><path d="M2 13H4V15H2zM20 13L17 13 17 10 15 10 15 13 12 13 12 15 15 15 15 18 17 18 17 15 20 15zM13 30H19V32H13zM11 26H21V28H11z"></path><path d="M16,4C10.5,4,6,8.5,6,14c0,4.4,2,6.3,3.5,7.6c1,0.9,1.5,1.5,1.5,2.4h2c0-1.8-1.1-2.9-2.2-3.9C9.4,18.9,8,17.5,8,14 c0-4.4,3.6-8,8-8s8,3.6,8,8c0,3.5-1.4,4.9-2.8,6.1c-1.1,1-2.2,2-2.2,3.9h2c0-0.9,0.5-1.5,1.5-2.4C24,20.3,26,18.4,26,14 C26,8.5,21.5,4,16,4z"></path></g></switch></svg>`;
export default svgResultCarbonIcon;
