/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { svg } from 'lit';
import spread from '../../globals/directives/spread';
const svgResultCarbonIcon = ({ children, ...attrs } = {}) =>
  svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(
    attrs
  )}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<circle cx="23" cy="26" r="1"></circle><circle cx="9" cy="6" r="1"></circle><path d="M12,17h8c2.2056,0,4-1.7944,4-4v-3h2c1.1028,0,2-.8975,2-2V4c0-1.1025-.8972-2-2-2H6c-1.1028,0-2,.8975-2,2v4c0,1.1025,.8972,2,2,2H22v3c0,1.1025-.8972,2-2,2H12c-2.2056,0-4,1.7944-4,4v3h-2c-1.1028,0-2,.8975-2,2v4c0,1.1025,.8972,2,2,2H26c1.1028,0,2-.8975,2-2v-4c0-1.1025-.8972-2-2-2H10v-3c0-1.1025,.8972-2,2-2ZM6,4H26v4H6V4ZM26,28H6v-4H26v4Z"></path></svg>`;
export default svgResultCarbonIcon;
