/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { svg } from 'lit';
import spread from '../../globals/directives/spread';
const svgResultCarbonIcon = ({ children, ...attrs } = {}) =>
  svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(
    attrs
  )}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<switch ><g ><path d="M25,16c0-1.5-1.2-2.8-2.7-3c-1.1-2.4-3.5-4-6.3-4c-0.2,0-0.5,0-0.7,0.1C14.7,8.4,13.9,8,13,8c-1.7,0-3,1.3-3,3 c0,0.4,0.1,0.7,0.2,1.1C9.4,13.2,9,14.5,9,16s0.4,2.8,1.2,3.9C10.1,20.3,10,20.6,10,21c0,1.7,1.3,3,3,3c0.9,0,1.7-0.4,2.3-1.1 c0.2,0,0.5,0.1,0.7,0.1c2.8,0,5.2-1.7,6.3-4C23.8,18.8,25,17.5,25,16z M13,10c0.6,0,1,0.4,1,1s-0.4,1-1,1s-1-0.4-1-1 S12.4,10,13,10z M13,22c-0.6,0-1-0.4-1-1s0.4-1,1-1s1,0.4,1,1S13.6,22,13,22z M16,21c0-1.7-1.3-3-3-3c-0.5,0-1,0.1-1.4,0.4 C11.2,17.7,11,16.9,11,16s0.2-1.7,0.6-2.4C12,13.9,12.5,14,13,14c1.7,0,3-1.3,3-3c1.9,0,3.4,1,4.3,2.5C19.5,14.1,19,15,19,16 s0.5,1.9,1.3,2.5C19.4,20,17.9,21,16,21z M22,17c-0.6,0-1-0.4-1-1s0.4-1,1-1s1,0.4,1,1S22.6,17,22,17z"></path><path d="M16,31c-0.2,0-0.3,0-0.5-0.1l-12-7C3.2,23.7,3,23.4,3,23V9c0-0.4,0.2-0.7,0.5-0.9l12-7c0.3-0.2,0.7-0.2,1,0l12,7l-1,1.7 L16,3.2L5,9.6v12.9l11,6.4l11-6.4V15h2v8c0,0.4-0.2,0.7-0.5,0.9l-12,7C16.3,31,16.2,31,16,31z"></path></g></switch></svg>`;
export default svgResultCarbonIcon;
