/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { svg } from 'lit';
import spread from '../../globals/directives/spread';
const svgResultCarbonIcon = ({ children, ...attrs } = {}) =>
  svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(
    attrs
  )}" aria-hidden="true" width="24" height="24" viewBox="0 0 32 32">${children}<path d="M15 11.671H17V15.328H15z" transform="rotate(-45 16 13.5)"></path><path d="M15 16.672H17V20.329H15z" transform="rotate(-45 16 18.5)"></path><path d="M19,24H13a2.0023,2.0023,0,0,1-2-2V10a2.0023,2.0023,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2V22A2.0023,2.0023,0,0,1,19,24ZM13,10V22h6.0012L19,10Z"></path><path d="M16,31a.9988.9988,0,0,1-.5039-.1357l-12-7A1.0008,1.0008,0,0,1,3,23V9a.9994.9994,0,0,1,.4961-.8638l12-7a1,1,0,0,1,1.0078,0l12,7L27.4961,9.8638,16,3.1577,5,9.5742V22.4258l11,6.417,11-6.417V15h2v8a1.0008,1.0008,0,0,1-.4961.8643l-12,7A.9988.9988,0,0,1,16,31Z"></path></svg>`;
export default svgResultCarbonIcon;
