/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { svg } from 'lit';
import spread from '../../globals/directives/spread';
const svgResultCarbonIcon = ({ children, ...attrs } = {}) =>
  svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(
    attrs
  )}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path d="M23.6,11.6c1-0.6,1.7-1.5,2.1-2.6c0.4-1.1,0.4-2.2,0.1-3.3c-0.3-1.1-1-2-1.9-2.7c-0.9-0.7-2.1-1-3.2-1h-9.2	c-1.2,0-2.3,0.4-3.2,1C7.2,3.7,6.6,4.7,6.2,5.7C5.9,6.8,5.9,8,6.3,9c0.4,1.1,1.1,2,2.1,2.6c-0.7,0.5-1.4,1.1-1.8,1.9	C6.2,14.3,6,15.1,6,16c0,0.9,0.2,1.7,0.6,2.5c0.4,0.8,1,1.4,1.8,1.9c-1,0.6-1.7,1.5-2.1,2.6c-0.4,1.1-0.4,2.2-0.1,3.3	c0.3,1.1,1,2,2,2.7c0.9,0.7,2.1,1,3.2,1c1.4,0,2.8-0.6,3.9-1.5c1-1,1.6-2.3,1.6-3.7v-4.8c1,0.9,2.3,1.4,3.6,1.4h0.1	c1.2,0,2.3-0.4,3.2-1c0.9-0.7,1.6-1.6,1.9-2.7c0.3-1.1,0.3-2.2-0.1-3.3C25.3,13.1,24.5,12.2,23.6,11.6z M16.9,3.7h3.7	c0.5,0,1,0,1.4,0.2c0.5,0.2,0.9,0.4,1.2,0.8c0.4,0.3,0.6,0.7,0.8,1.2s0.3,0.9,0.3,1.4c0,0.5-0.1,1-0.3,1.4c-0.2,0.4-0.5,0.8-0.8,1.2	c-0.4,0.3-0.8,0.6-1.2,0.8c-0.5,0.2-1,0.2-1.4,0.2h-3.7V3.7z M11.4,3.7h3.7v7h-3.7c-0.9,0-1.8-0.4-2.4-1.1C8.3,9,8,8.1,8,7.2	s0.4-1.8,1-2.4C9.6,4.2,10.5,3.8,11.4,3.7L11.4,3.7z M7.8,16c0-0.9,0.4-1.8,1.1-2.5c0.7-0.7,1.6-1,2.6-1h3.7v7h-3.7	c-1,0-1.9-0.4-2.6-1C8.2,17.8,7.8,16.9,7.8,16L7.8,16z M15.1,24.7c0,1-0.4,1.9-1.1,2.5c-0.7,0.7-1.6,1-2.6,1c-0.5,0-1,0-1.4-0.2	c-0.5-0.2-0.9-0.4-1.2-0.7c-0.4-0.3-0.6-0.7-0.8-1.2c-0.2-0.4-0.3-0.9-0.3-1.4c0-0.5,0.1-1,0.3-1.4c0.2-0.4,0.5-0.8,0.8-1.2	c0.4-0.3,0.8-0.6,1.2-0.8c0.5-0.2,1-0.2,1.4-0.2h3.7L15.1,24.7z M20.6,19.5h-0.1c-0.9,0-1.8-0.4-2.4-1.1c-0.6-0.7-1-1.5-1-2.4	c0-0.9,0.4-1.8,1-2.4c0.6-0.7,1.5-1,2.4-1.1h0.1c0.5,0,1,0,1.4,0.2c0.5,0.2,0.9,0.4,1.2,0.8c0.4,0.3,0.6,0.7,0.8,1.2	c0.2,0.4,0.3,0.9,0.3,1.4c0,0.5-0.1,1-0.3,1.4c-0.2,0.4-0.5,0.8-0.8,1.2c-0.4,0.3-0.8,0.6-1.2,0.8C21.6,19.5,21.1,19.5,20.6,19.5	L20.6,19.5z"></path></svg>`;
export default svgResultCarbonIcon;
