/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { svg } from 'lit';
import spread from '../../globals/directives/spread';
const svgResultCarbonIcon = ({ children, ...attrs } = {}) =>
  svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(
    attrs
  )}" aria-hidden="true" width="24" height="24" viewBox="0 0 32 32">${children}<path d="M18,23H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h4a2,2,0,0,1,2,2V21A2,2,0,0,1,18,23ZM14,11h0V21h4V11Z"></path><path d="M15 15H17V17H15z"></path></svg>`;
export default svgResultCarbonIcon;
