/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { svg } from 'lit';
import spread from '../../globals/directives/spread';
const svgResultCarbonIcon = ({ children, ...attrs } = {}) =>
  svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(
    attrs
  )}" aria-hidden="true" width="24" height="24" viewBox="0 0 24 24">${children}<path d="M6.8,11.2c-1.8,0-3.2,1.7-3.2,3.3c0,1.5,1.5,3.2,3.2,3.2H10v1.5H6.8C4.6,19.2,2,17,2,14.5s2-4.8,4.8-4.8	h12.4l-3-3l1.1-1.1l4.8,4.8l-4.8,4.8l-1.1-1.1l3-3H6.8z"></path></svg>`;
export default svgResultCarbonIcon;
