/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { svg } from 'lit';
import spread from '../../globals/directives/spread';
const svgResultCarbonIcon = ({ children, ...attrs } = {}) =>
  svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(
    attrs
  )}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path d="M26,20l1.4272,1.9028L23,26.9629l-4.4272-5.06L20,20h6m1-2H19l-3,4,7,8,7-8-3-4Z"></path><path d="M16,26H12V18h2V16H12a2,2,0,0,0-2,2v8H6V6h4v4a2,2,0,0,0,2,2h8a2,2,0,0,0,2-2V6.41l4,4V16h2V10a1,1,0,0,0-.29-.71l-5-5A.9989.9989,0,0,0,22,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H16ZM12,6h8v4H12Z"></path></svg>`;
export default svgResultCarbonIcon;
