/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import ChevronRight16 from '../../icons/chevron--right/16.js';
import { prefix } from '../../globals/settings.js';
import '../skeleton-text/skeleton-text.js';
import styles from './accordion.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of accordion item.
 */
let CDSAccordionItemSkeleton = class CDSAccordionItemSkeleton extends LitElement {
    render() {
        return html `
      <span class="${prefix}--accordion__heading">
        ${ChevronRight16({
            part: 'expando-icon',
            class: `${prefix}--accordion__arrow`,
        })}
        <cds-skeleton-text
          class="${prefix}--accordion__title"></cds-skeleton-text>
      </span>
    `;
    }
};
CDSAccordionItemSkeleton.styles = styles;
CDSAccordionItemSkeleton = __decorate([
    carbonElement(`${prefix}-accordion-item-skeleton`)
], CDSAccordionItemSkeleton);
var CDSAccordionItemSkeleton$1 = CDSAccordionItemSkeleton;

export { CDSAccordionItemSkeleton$1 as default };
//# sourceMappingURL=accordion-item-skeleton.js.map
