/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2022, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Breakpoints for accordion items. It's different from one in `@carbon/layout` library.
 */
var ACCORDION_ITEM_BREAKPOINT;
(function (ACCORDION_ITEM_BREAKPOINT) {
    /**
     * Small breakpoint.
     */
    ACCORDION_ITEM_BREAKPOINT["SMALL"] = "sm";
    /**
     * Medium breakpoint.
     */
    ACCORDION_ITEM_BREAKPOINT["MEDIUM"] = "md";
})(ACCORDION_ITEM_BREAKPOINT || (ACCORDION_ITEM_BREAKPOINT = {}));
/**
 * Accordion size.
 */
var ACCORDION_SIZE;
(function (ACCORDION_SIZE) {
    /**
     * Small size.
     */
    ACCORDION_SIZE["SMALL"] = "sm";
    /**
     * Medium size.
     */
    ACCORDION_SIZE["MEDIUM"] = "md";
    /**
     * Large size.
     */
    ACCORDION_SIZE["LARGE"] = "lg";
})(ACCORDION_SIZE || (ACCORDION_SIZE = {}));
/**
 * Specify the alignment of the accordion heading title and chevron.
 */
var ACCORDION_ALIGNMENT;
(function (ACCORDION_ALIGNMENT) {
    /**
     * Alignment to the start
     */
    ACCORDION_ALIGNMENT["START"] = "start";
    /**
     * Alignment to the end
     */
    ACCORDION_ALIGNMENT["END"] = "END";
})(ACCORDION_ALIGNMENT || (ACCORDION_ALIGNMENT = {}));

export { ACCORDION_ALIGNMENT, ACCORDION_ITEM_BREAKPOINT, ACCORDION_SIZE };
//# sourceMappingURL=defs.js.map
