/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import CDSButton from '../button/button.js';
import styles from './ai-label.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * AI Label action button.
 *
 * @element cds-ai-label-action-button
 */
let CDSAILabelActionButton = class CDSAILabelActionButton extends CDSButton {
    constructor() {
        super(...arguments);
        /**
         * The shadow slot this ai-label-action should be in.
         */
        this.slot = 'actions';
    }
};
CDSAILabelActionButton.styles = styles;
__decorate([
    property({ reflect: true })
], CDSAILabelActionButton.prototype, "slot", void 0);
CDSAILabelActionButton = __decorate([
    carbonElement(`${prefix}-ai-label-action-button`)
], CDSAILabelActionButton);
var CDSAILabelActionButton$1 = CDSAILabelActionButton;

export { CDSAILabelActionButton$1 as default };
//# sourceMappingURL=ai-label-action-button.js.map
