/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import { property } from 'lit/decorators.js';
import styles from './ai-skeleton.scss.js';
import '../skeleton-icon/skeleton-icon.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * AI skeleton icon.
 *
 * @element cds-ai-skeleton-icon
 */
let CDSAISkeletonIcon = class CDSAISkeletonIcon extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Custom styles to apply to skeleton icon
         */
        this.customStyles = '';
    }
    render() {
        return html `<cds-skeleton-icon
      class="${prefix}--skeleton__icon--ai"
      style="${this.customStyles}"></cds-skeleton-icon>`;
    }
};
CDSAISkeletonIcon.styles = styles;
__decorate([
    property({ attribute: 'custom-styles' })
], CDSAISkeletonIcon.prototype, "customStyles", void 0);
CDSAISkeletonIcon = __decorate([
    carbonElement(`${prefix}-ai-skeleton-icon`)
], CDSAISkeletonIcon);
var CDSAISkeletonIcon$1 = CDSAISkeletonIcon;

export { CDSAISkeletonIcon$1 as default };
//# sourceMappingURL=ai-skeleton-icon.js.map
