/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './ai-skeleton.scss.js';
import '../skeleton-placeholder/skeleton-placeholder.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * AI skeleton placeholder.
 *
 * @element cds-ai-skeleton-placeholder
 */
let CDSAISkeletonPlaceholder = class CDSAISkeletonPlaceholder extends LitElement {
    render() {
        return html `<cds-skeleton-placeholder
      optional-classes="${prefix}--skeleton__placeholder--ai"></cds-skeleton-placeholder>`;
    }
};
CDSAISkeletonPlaceholder.styles = styles;
CDSAISkeletonPlaceholder = __decorate([
    carbonElement(`${prefix}-ai-skeleton-placeholder`)
], CDSAISkeletonPlaceholder);
var CDSAISkeletonPlaceholder$1 = CDSAISkeletonPlaceholder;

export { CDSAISkeletonPlaceholder$1 as default };
//# sourceMappingURL=ai-skeleton-placeholder.js.map
