/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { LitElement } from 'lit';
import '../skeleton-text/skeleton-text';
/**
 * AI skeleton text.
 *
 * @element cds-ai-skeleton-text
 */
declare class CDSAISkeletonText extends LitElement {
    /**
     * Generates skeleton text at a larger size.
     */
    heading: boolean;
    /**
     * width (in px or %) of single line of text or max-width of paragraph lines
     */
    width: string;
    /**
     * will generate multiple lines of text
     */
    paragraph: boolean;
    /**
     * the number of lines in a paragraph
     */
    lineCount: number;
    render(): import("lit-html").TemplateResult<1>;
    static styles: any;
}
export default CDSAISkeletonText;
