/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './ai-skeleton.scss.js';
import '../skeleton-text/skeleton-text.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * AI skeleton text.
 *
 * @element cds-ai-skeleton-text
 */
let CDSAISkeletonText = class CDSAISkeletonText extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Generates skeleton text at a larger size.
         */
        this.heading = false;
        /**
         * width (in px or %) of single line of text or max-width of paragraph lines
         */
        this.width = '100%';
        /**
         * will generate multiple lines of text
         */
        this.paragraph = false;
        /**
         * the number of lines in a paragraph
         */
        this.lineCount = 3;
    }
    render() {
        const { heading, width, lineCount, paragraph } = this;
        return html `<cds-skeleton-text
      type="${heading ? 'heading' : ''}"
      width="${width}"
      linecount="${lineCount}"
      ?paragraph="${paragraph}"
      optional-classes="${prefix}--skeleton__text--ai"></cds-skeleton-text>`;
    }
};
CDSAISkeletonText.styles = styles;
__decorate([
    property({ type: Boolean, reflect: true })
], CDSAISkeletonText.prototype, "heading", void 0);
__decorate([
    property({ reflect: true })
], CDSAISkeletonText.prototype, "width", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSAISkeletonText.prototype, "paragraph", void 0);
__decorate([
    property({ type: Number, reflect: true })
], CDSAISkeletonText.prototype, "lineCount", void 0);
CDSAISkeletonText = __decorate([
    carbonElement(`${prefix}-ai-skeleton-text`)
], CDSAISkeletonText);
var CDSAISkeletonText$1 = CDSAISkeletonText;

export { CDSAISkeletonText$1 as default };
//# sourceMappingURL=ai-skeleton-text.js.map
