/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { html } from 'lit';
import { prefix } from '../../globals/settings.js';
import CDSLink from '../link/link.js';
import styles from './breadcrumb.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Link in breadcrumb.
 *
 * @element cds-breadcrumb-link
 */
let CDSBreadcrumbLink = class CDSBreadcrumbLink extends CDSLink {
    render() {
        return html `
      ${this.href
            ? super.render()
            : html `<span class="${prefix}--link"><slot></slot></span>`}
    `;
    }
};
CDSBreadcrumbLink.styles = styles;
CDSBreadcrumbLink = __decorate([
    carbonElement(`${prefix}-breadcrumb-link`)
], CDSBreadcrumbLink);
var CDSBreadcrumbLink$1 = CDSBreadcrumbLink;

export { CDSBreadcrumbLink$1 as default };
//# sourceMappingURL=breadcrumb-link.js.map
