/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { html } from 'lit';
import { prefix } from '../../globals/settings.js';
import OverflowMenuHorizontal16 from '../../icons/overflow-menu--horizontal/16.js';
import CDSOverflowMenu from '../overflow-menu/overflow-menu.js';
import styles from './breadcrumb.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Overflow menu in breadcrumb.
 *
 * @element cds-breadcrumb-overflow-menu
 */
let CDSBreadcrumbOverflowMenu = class CDSBreadcrumbOverflowMenu extends CDSOverflowMenu {
    render() {
        return html `
      <slot name="icon">
        ${OverflowMenuHorizontal16({
            class: `${prefix}--overflow-menu__icon`,
        })}
      </slot>
    `;
    }
};
CDSBreadcrumbOverflowMenu.styles = styles;
CDSBreadcrumbOverflowMenu = __decorate([
    carbonElement(`${prefix}-breadcrumb-overflow-menu`)
], CDSBreadcrumbOverflowMenu);
var CDSBreadcrumbOverflowMenu$1 = CDSBreadcrumbOverflowMenu;

export { CDSBreadcrumbOverflowMenu$1 as default };
//# sourceMappingURL=breadcrumb-overflow-menu.js.map
