/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './breadcrumb.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
const renderItem = () => {
    return html `
    <div class="${prefix}--breadcrumb-item">
      <span class="${prefix}--link">&nbsp;</span>
    </div>
  `;
};
/**
 * Skeleton of breadcrumb.
 */
let CDSBreadcrumbSkeleton = class CDSBreadcrumbSkeleton extends LitElement {
    render() {
        return html `
      <div class="${prefix}--breadcrumb ${prefix}--skeleton">
        ${renderItem()} ${renderItem()} ${renderItem()}
      </div>
    `;
    }
};
CDSBreadcrumbSkeleton.styles = styles;
CDSBreadcrumbSkeleton = __decorate([
    carbonElement(`${prefix}-breadcrumb-skeleton`)
], CDSBreadcrumbSkeleton);
var CDSBreadcrumbSkeleton$1 = CDSBreadcrumbSkeleton;

export { CDSBreadcrumbSkeleton$1 as default };
//# sourceMappingURL=breadcrumb-skeleton.js.map
