/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { classMap } from 'lit/directives/class-map.js';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './breadcrumb.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Breadcrumb.
 *
 * @element cds-breadcrumb
 */
let CDSBreadcrumb = class CDSBreadcrumb extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Optional prop to omit the trailing slash for the breadcrumbs
         */
        this.noTrailingSlash = false;
    }
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'navigation');
        }
        super.connectedCallback();
    }
    render() {
        const classes = classMap({
            [`${prefix}--breadcrumb`]: true,
            [`${prefix}--breadcrumb--no-trailing-slash`]: this.noTrailingSlash,
        });
        return html `
      <ol class="${classes}">
        <slot></slot>
      </ol>
    `;
    }
};
CDSBreadcrumb.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property({ type: Boolean, reflect: true, attribute: 'no-trailing-slash' })
], CDSBreadcrumb.prototype, "noTrailingSlash", void 0);
CDSBreadcrumb = __decorate([
    carbonElement(`${prefix}-breadcrumb`)
], CDSBreadcrumb);
var CDSBreadcrumb$1 = CDSBreadcrumb;

export { CDSBreadcrumb$1 as default };
//# sourceMappingURL=breadcrumb.js.map
