/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import buttonStyles from './button.scss.js';
import { prefix } from '../../globals/settings.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Button set without button checks
 *
 * @element cds-button-set-base
 */
let CDSButtonSetBase = class CDSButtonSetBase extends LitElement {
    render() {
        return html `<slot></slot>`;
    }
    connectedCallback() {
        super.connectedCallback();
        this.setAttribute('role', 'list');
    }
};
CDSButtonSetBase.styles = buttonStyles; // `styles` here is a `CSSResult` generated by custom WebPack loader
CDSButtonSetBase = __decorate([
    carbonElement(`${prefix}-button-set-base`)
], CDSButtonSetBase);
/* @__GENERATE_REACT_CUSTOM_ELEMENT_TYPE__ */
var CDSButtonSetBase$1 = CDSButtonSetBase;

export { CDSButtonSetBase$1 as default };
//# sourceMappingURL=button-set-base.js.map
