/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { html } from 'lit';
import { BUTTON_KIND } from './defs.js';
import buttonStyles from './button.scss.js';
import { prefix } from '../../globals/settings.js';
import CDSButtonSetBase from './button-set-base.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Button set.
 *
 * @element cds-button-set
 */
let CDSButtonSet = class CDSButtonSet extends CDSButtonSetBase {
    /**
     * Handler for @slotchange, set the first cds-button to kind secondary and primary for the remaining ones
     *
     * @private
     */
    _handleSlotChange(event) {
        const childItems = event.target
            .assignedNodes()
            .filter((elem) => elem.matches !== undefined
            ? elem.matches(this.constructor.selectorItem)
            : false);
        childItems.forEach((elem, index) => {
            elem.setAttribute('kind', index === 0 ? BUTTON_KIND.SECONDARY : BUTTON_KIND.PRIMARY);
        });
        const update = new CustomEvent(`${prefix}-btn-set-update`, {
            bubbles: true,
            cancelable: true,
            composed: true,
        });
        this.dispatchEvent(update);
    }
    render() {
        return html ` <slot @slotchange="${this._handleSlotChange}"></slot> `;
    }
    /**
     * A selector that will return the child items.
     */
    static get selectorItem() {
        return `${prefix}-button`;
    }
};
CDSButtonSet.styles = buttonStyles; // `styles` here is a `CSSResult` generated by custom Vite loader
CDSButtonSet = __decorate([
    carbonElement(`${prefix}-button-set`)
], CDSButtonSet);
var CDSButtonSet$1 = CDSButtonSet;

export { CDSButtonSet$1 as default };
//# sourceMappingURL=button-set.js.map
