/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { css } from 'lit';

var buttonStyles = css([".cds--layout--size-xs{--cds-layout-size-height-context:var(--cds-layout-size-height-xs,1.5rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-xs{--cds-layout-size-height:var(--cds-layout-size-height-context,var(--cds-layout-size-height-xs,1.5rem))}.cds--layout-constraint--size__min-xs{--cds-layout-size-height-min:var(--cds-layout-size-height-xs,1.5rem)}.cds--layout-constraint--size__max-xs{--cds-layout-size-height-max:var(--cds-layout-size-height-xs,1.5rem)}.cds--layout--size-sm{--cds-layout-size-height-context:var(--cds-layout-size-height-sm,2rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-sm{--cds-layout-size-height:var(--cds-layout-size-height-context,var(--cds-layout-size-height-sm,2rem))}.cds--layout-constraint--size__min-sm{--cds-layout-size-height-min:var(--cds-layout-size-height-sm,2rem)}.cds--layout-constraint--size__max-sm{--cds-layout-size-height-max:var(--cds-layout-size-height-sm,2rem)}.cds--layout--size-md{--cds-layout-size-height-context:var(--cds-layout-size-height-md,2.5rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-md{--cds-layout-size-height:var(--cds-layout-size-height-context,var(--cds-layout-size-height-md,2.5rem))}.cds--layout-constraint--size__min-md{--cds-layout-size-height-min:var(--cds-layout-size-height-md,2.5rem)}.cds--layout-constraint--size__max-md{--cds-layout-size-height-max:var(--cds-layout-size-height-md,2.5rem)}.cds--layout--size-lg{--cds-layout-size-height-context:var(--cds-layout-size-height-lg,3rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-lg{--cds-layout-size-height:var(--cds-layout-size-height-context,var(--cds-layout-size-height-lg,3rem))}.cds--layout-constraint--size__min-lg{--cds-layout-size-height-min:var(--cds-layout-size-height-lg,3rem)}.cds--layout-constraint--size__max-lg{--cds-layout-size-height-max:var(--cds-layout-size-height-lg,3rem)}.cds--layout--size-xl{--cds-layout-size-height-context:var(--cds-layout-size-height-xl,4rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-xl{--cds-layout-size-height:var(--cds-layout-size-height-context,var(--cds-layout-size-height-xl,4rem))}.cds--layout-constraint--size__min-xl{--cds-layout-size-height-min:var(--cds-layout-size-height-xl,4rem)}.cds--layout-constraint--size__max-xl{--cds-layout-size-height-max:var(--cds-layout-size-height-xl,4rem)}.cds--layout--size-2xl{--cds-layout-size-height-context:var(--cds-layout-size-height-2xl,5rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-2xl{--cds-layout-size-height:var(--cds-layout-size-height-context,var(--cds-layout-size-height-2xl,5rem))}.cds--layout-constraint--size__min-2xl{--cds-layout-size-height-min:var(--cds-layout-size-height-2xl,5rem)}.cds--layout-constraint--size__max-2xl{--cds-layout-size-height-max:var(--cds-layout-size-height-2xl,5rem)}.cds--layout--density-condensed{--cds-layout-density-padding-inline-context:var(--cds-layout-density-padding-inline-condensed,0.5rem);--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context)}.cds--layout-constraint--density__default-condensed{--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context,var(--cds-layout-density-padding-inline-condensed,0.5rem))}.cds--layout-constraint--density__min-condensed{--cds-layout-density-padding-inline-min:var(--cds-layout-density-padding-inline-condensed,0.5rem)}.cds--layout-constraint--density__max-condensed{--cds-layout-density-padding-inline-max:var(--cds-layout-density-padding-inline-condensed,0.5rem)}.cds--layout--density-normal{--cds-layout-density-padding-inline-context:var(--cds-layout-density-padding-inline-normal,1rem);--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context)}.cds--layout-constraint--density__default-normal{--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context,var(--cds-layout-density-padding-inline-normal,1rem))}.cds--layout-constraint--density__min-normal{--cds-layout-density-padding-inline-min:var(--cds-layout-density-padding-inline-normal,1rem)}.cds--layout-constraint--density__max-normal{--cds-layout-density-padding-inline-max:var(--cds-layout-density-padding-inline-normal,1rem)}:root{--cds-layout-size-height-xs:1.5rem;--cds-layout-size-height-sm:2rem;--cds-layout-size-height-md:2.5rem;--cds-layout-size-height-lg:3rem;--cds-layout-size-height-xl:4rem;--cds-layout-size-height-2xl:5rem;--cds-layout-size-height-min:0px;--cds-layout-size-height-max:999999999px;--cds-layout-density-padding-inline-condensed:0.5rem;--cds-layout-density-padding-inline-normal:1rem;--cds-layout-density-padding-inline-min:0px;--cds-layout-density-padding-inline-max:999999999px}.cds--layer-one,:root{--cds-layer:var(--cds-layer-01,#f4f4f4);--cds-layer-active:var(--cds-layer-active-01,#c6c6c6);--cds-layer-hover:var(--cds-layer-hover-01,#e8e8e8);--cds-layer-selected:var(--cds-layer-selected-01,#e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-01,#d1d1d1);--cds-layer-accent:var(--cds-layer-accent-01,#e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-01,#d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-01,#a8a8a8);--cds-field:var(--cds-field-01,#f4f4f4);--cds-field-hover:var(--cds-field-hover-01,#e8e8e8);--cds-border-subtle:var(--cds-border-subtle-00,#e0e0e0);--cds-border-subtle-selected:var(--cds-border-subtle-selected-01,#c6c6c6);--cds-border-strong:var(--cds-border-strong-01,#8d8d8d);--cds-border-tile:var(--cds-border-tile-01,#c6c6c6)}.cds--layer-two{--cds-layer:var(--cds-layer-02,#fff);--cds-layer-active:var(--cds-layer-active-02,#c6c6c6);--cds-layer-hover:var(--cds-layer-hover-02,#e8e8e8);--cds-layer-selected:var(--cds-layer-selected-02,#e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-02,#d1d1d1);--cds-layer-accent:var(--cds-layer-accent-02,#e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-02,#d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-02,#a8a8a8);--cds-field:var(--cds-field-02,#fff);--cds-field-hover:var(--cds-field-hover-02,#e8e8e8);--cds-border-subtle:var(--cds-border-subtle-01,#c6c6c6);--cds-border-subtle-selected:var(--cds-border-subtle-selected-02,#c6c6c6);--cds-border-strong:var(--cds-border-strong-02,#8d8d8d);--cds-border-tile:var(--cds-border-tile-02,#a8a8a8)}.cds--layer-three{--cds-layer:var(--cds-layer-03,#f4f4f4);--cds-layer-active:var(--cds-layer-active-03,#c6c6c6);--cds-layer-hover:var(--cds-layer-hover-03,#e8e8e8);--cds-layer-selected:var(--cds-layer-selected-03,#e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-03,#d1d1d1);--cds-layer-accent:var(--cds-layer-accent-03,#e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-03,#d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-03,#a8a8a8);--cds-field:var(--cds-field-03,#f4f4f4);--cds-field-hover:var(--cds-field-hover-03,#e8e8e8);--cds-border-subtle:var(--cds-border-subtle-02,#e0e0e0);--cds-border-subtle-selected:var(--cds-border-subtle-selected-03,#c6c6c6);--cds-border-strong:var(--cds-border-strong-03,#8d8d8d);--cds-border-tile:var(--cds-border-tile-03,#c6c6c6)}@keyframes cds--hide-feedback{0%{opacity:1;visibility:inherit}to{opacity:0;visibility:hidden}}@keyframes cds--show-feedback{0%{opacity:0;visibility:hidden}to{opacity:1;visibility:inherit}}@keyframes cds--skeleton{0%{opacity:.3;transform:scaleX(0);transform-origin:left}20%{opacity:1;transform:scaleX(1);transform-origin:left}28%{transform:scaleX(1);transform-origin:right}51%{transform:scaleX(0);transform-origin:right}58%{transform:scaleX(0);transform-origin:right}82%{transform:scaleX(1);transform-origin:right}83%{transform:scaleX(1);transform-origin:left}96%{transform:scaleX(0);transform-origin:left}to{opacity:.3;transform:scaleX(0);transform-origin:left}}.cds--assistive-text,.cds--visually-hidden{block-size:1px;border:0;margin:-1px;overflow:hidden;padding:0;position:absolute;clip:rect(0,0,0,0);inline-size:1px;visibility:inherit;white-space:nowrap}.cds--popover-container{display:inline-block}.cds--popover-container:not(.cds--popover--auto-align){position:relative}.cds--popover--high-contrast .cds--popover{--cds-popover-background-color:var(--cds-background-inverse,#393939);--cds-popover-text-color:var(--cds-text-inverse,#fff)}.cds--popover--drop-shadow .cds--popover>.cds--popover-content{filter:drop-shadow(0 2px 2px rgba(0,0,0,.2))}.cds--popover--caret{--cds-popover-offset:0.625rem}.cds--popover{filter:var(--cds-popover-drop-shadow,none);inset:0;pointer-events:none;position:absolute;z-index:6000}.cds--popover-content{--cds-layout-size-height-sm:2rem;--cds-layout-size-height-md:2.5rem;--cds-layout-size-height-lg:3rem;background-color:var(--cds-popover-background-color,var(--cds-layer));border:0;border-radius:var(--cds-popover-border-radius,2px);box-sizing:border-box;color:var(--cds-popover-text-color,var(--cds-text-primary,#161616));display:none;font-family:inherit;font-size:100%;inline-size:-moz-max-content;inline-size:max-content;margin:0;max-inline-size:23rem;padding:0;pointer-events:auto;position:absolute;vertical-align:baseline;z-index:6000}.cds--layout--size-sm .cds--popover-content{--cds-layout-size-height:var(--cds-layout-size-height-sm)}.cds--layout--size-md .cds--popover-content{--cds-layout-size-height:var(--cds-layout-size-height-md)}.cds--layout--size-lg .cds--popover-content{--cds-layout-size-height:var(--cds-layout-size-height-lg)}.cds--popover-content *,.cds--popover-content :after,.cds--popover-content :before{box-sizing:inherit}.cds--popover--open>.cds--popover>.cds--popover-content{display:block}.cds--popover-content:before{content:\"\";display:none;position:absolute}.cds--popover--open>.cds--popover>.cds--popover-content:before{display:block}.cds--popover--auto-align.cds--popover-caret,.cds--popover-caret{background-color:var(--cds-popover-background-color,var(--cds-layer));display:none;position:absolute;will-change:transform;z-index:6000}.cds--popover--auto-align.cds--popover--caret.cds--popover--open>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--caret.cds--popover--open>.cds--popover>.cds--popover-caret{display:block}.cds--popover--tab-tip>.cds--popover>.cds--popover-caret{display:none}.cds--popover--bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-end:0;inset-inline-start:50%;transform:translate(-50%,calc(100% + var(--cds-popover-offset, 0rem)))}[dir=rtl] .cds--popover--bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{transform:translate(50%,calc(100% + var(--cds-popover-offset, 0rem)))}.cds--popover--bottom-left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--bottom-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-end:0;inset-inline-start:0;transform:translate(calc(var(--cds-popover-offset, 0rem)*-1),calc(100% + var(--cds-popover-offset, 0rem)))}[dir=rtl] .cds--popover--bottom-left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--bottom-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-inline-end:0;inset-inline-start:auto}.cds--popover--bottom-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--bottom-right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-end:0;inset-inline-end:0;transform:translate(var(--cds-popover-offset,0),calc(100% + var(--cds-popover-offset, 0rem)))}[dir=rtl] .cds--popover--bottom-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--bottom-right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-inline-start:0}.cds--popover--bottom-end>.cds--popover>.cds--popover-content:before,.cds--popover--bottom-left>.cds--popover>.cds--popover-content:before,.cds--popover--bottom-right>.cds--popover>.cds--popover-content:before,.cds--popover--bottom-start>.cds--popover>.cds--popover-content:before,.cds--popover--bottom>.cds--popover>.cds--popover-content:before{block-size:var(--cds-popover-offset,0);inset-block-start:0;inset-inline:0;transform:translateY(-100%)}.cds--popover--bottom-end>.cds--popover>.cds--popover-caret,.cds--popover--bottom-left>.cds--popover>.cds--popover-caret,.cds--popover--bottom-right>.cds--popover>.cds--popover-caret,.cds--popover--bottom-start>.cds--popover>.cds--popover-caret,.cds--popover--bottom>.cds--popover>.cds--popover-caret{block-size:var(--cds-popover-caret-height,.375rem);clip-path:polygon(0 100%,50% 0,100% 100%);inline-size:var(--cds-popover-caret-width,.75rem);inset-block-end:0;inset-inline-start:50%;transform:translate(-50%,var(--cds-popover-offset,0))}[dir=rtl] .cds--popover--bottom-end>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--bottom-left>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--bottom-right>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--bottom-start>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--bottom>.cds--popover>.cds--popover-caret{transform:translate(50%,var(--cds-popover-offset,0))}.cds--popover--bottom-end.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--bottom-left.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--bottom-right.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--bottom-start.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--bottom.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret{block-size:var(--cds-popover-caret-height,.375rem);clip-path:polygon(0 100%,50% 0,100% 100%);inline-size:var(--cds-popover-caret-width,.75rem)}.cds--popover--top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:0;inset-inline-start:50%;transform:translate(-50%,calc(-100% - var(--cds-popover-offset, 0rem)))}[dir=rtl] .cds--popover--top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{transform:translate(50%,calc(-100% - var(--cds-popover-offset, 0rem)))}.cds--popover--top-left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--top-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:0;inset-inline-start:0;transform:translate(calc(var(--cds-popover-offset, 0rem)*-1),calc(-100% - var(--cds-popover-offset, 0rem)))}[dir=rtl] .cds--popover--top-left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--top-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-inline-end:0;inset-inline-start:auto}.cds--popover--top-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--top-right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:0;inset-inline-end:0;transform:translate(var(--cds-popover-offset,0),calc(-100% - var(--cds-popover-offset, 0rem)))}[dir=rtl] .cds--popover--top-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--top-right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-inline-start:0}.cds--popover--top-end>.cds--popover>.cds--popover-content:before,.cds--popover--top-left>.cds--popover>.cds--popover-content:before,.cds--popover--top-right>.cds--popover>.cds--popover-content:before,.cds--popover--top-start>.cds--popover>.cds--popover-content:before,.cds--popover--top>.cds--popover>.cds--popover-content:before{block-size:var(--cds-popover-offset,0);inset-block-end:0;inset-inline:0;transform:translateY(100%)}.cds--popover--top-end>.cds--popover>.cds--popover-caret,.cds--popover--top-left>.cds--popover>.cds--popover-caret,.cds--popover--top-right>.cds--popover>.cds--popover-caret,.cds--popover--top-start>.cds--popover>.cds--popover-caret,.cds--popover--top>.cds--popover>.cds--popover-caret{block-size:var(--cds-popover-caret-height,.375rem);clip-path:polygon(0 0,50% 100%,100% 0);inline-size:var(--cds-popover-caret-width,.75rem);inset-block-start:0;inset-inline-start:50%;transform:translate(-50%,calc(var(--cds-popover-offset, 0rem)*-1))}[dir=rtl] .cds--popover--top-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--top-left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--top-right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--top-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret{transform:translate(50%,calc(var(--cds-popover-offset, 0rem)*-1))}.cds--popover--top-end.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--top-left.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--top-right.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--top-start.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--top.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret{block-size:var(--cds-popover-caret-height,.375rem);clip-path:polygon(0 0,50% 100%,100% 0);inline-size:var(--cds-popover-caret-width,.75rem)}.cds--popover--right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:50%;inset-inline-start:100%;transform:translate(var(--cds-popover-offset,0),-50%)}.cds--popover--right-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--right-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:50%;inset-inline-start:100%;transform:translate(var(--cds-popover-offset,0),calc(var(--cds-popover-offset, 0rem)*.5*-1 - 16px))}.cds--popover--right-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--right-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-end:50%;inset-inline-start:100%;transform:translate(var(--cds-popover-offset,0),calc(var(--cds-popover-offset, 0rem)*.5 + 16px))}[dir=rtl] .cds--popover--right-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--right-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--right-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--right-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-inline-end:100%;inset-inline-start:auto}.cds--popover--right-bottom>.cds--popover>.cds--popover-content:before,.cds--popover--right-end>.cds--popover>.cds--popover-content:before,.cds--popover--right-start>.cds--popover>.cds--popover-content:before,.cds--popover--right-top>.cds--popover>.cds--popover-content:before,.cds--popover--right>.cds--popover>.cds--popover-content:before{inline-size:var(--cds-popover-offset,0);inset-block:0;inset-inline-start:0;transform:translateX(-100%)}.cds--popover--right-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--right-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--right-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--right-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret{block-size:var(--cds-popover-caret-width,.75rem);clip-path:polygon(0 50%,100% 0,100% 100%);inline-size:var(--cds-popover-caret-height,.375rem);inset-block-start:50%;inset-inline-start:100%;transform:translate(calc(var(--cds-popover-offset, 0rem) - 100%),-50%)}[dir=rtl] .cds--popover--right-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--right-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--right-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--right-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret{inset-inline-end:100%;inset-inline-start:auto}.cds--popover--right-bottom.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--right-end.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--right-start.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--right-top.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--right.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret{block-size:var(--cds-popover-caret-width,.75rem);clip-path:polygon(0 50%,100% 0,100% 100%);inline-size:var(--cds-popover-caret-height,.375rem)}.cds--popover--left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:50%;inset-inline-end:100%;transform:translate(calc(var(--cds-popover-offset, 0rem)*-1 + .1px),-50%)}.cds--popover--left-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--left-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:50%;inset-inline-end:100%;transform:translate(calc(var(--cds-popover-offset, 0rem)*-1),calc(var(--cds-popover-offset, 0rem)*-.5 - 16px))}.cds--popover--left-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--left-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-end:50%;inset-inline-end:100%;transform:translate(calc(var(--cds-popover-offset, 0rem)*-1),calc(var(--cds-popover-offset, 0rem)*.5 + 16px))}[dir=rtl] .cds--popover--left-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--left-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--left-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--left-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-inline-end:auto;inset-inline-start:100%}.cds--popover--left-bottom>.cds--popover>.cds--popover-content:before,.cds--popover--left-end>.cds--popover>.cds--popover-content:before,.cds--popover--left-start>.cds--popover>.cds--popover-content:before,.cds--popover--left-top>.cds--popover>.cds--popover-content:before,.cds--popover--left>.cds--popover>.cds--popover-content:before{inline-size:var(--cds-popover-offset,0);inset-block:0;inset-inline-end:0;transform:translateX(100%)}.cds--popover--left-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--left-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--left-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--left-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret{block-size:var(--cds-popover-caret-width,.75rem);clip-path:polygon(0 0,100% 50%,0 100%);inline-size:var(--cds-popover-caret-height,.375rem);inset-block-start:50%;inset-inline-end:100%;transform:translate(calc(var(--cds-popover-offset, 0rem)*-1 + 100%),-50%)}[dir=rtl] .cds--popover--left-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--left-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--left-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--left-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret{inset-inline-end:auto;inset-inline-start:100%}.cds--popover--left-bottom.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--left-end.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--left-start.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--left-top.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--left.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret{block-size:var(--cds-popover-caret-width,.75rem);clip-path:polygon(0 0,100% 50%,0 100%);inline-size:var(--cds-popover-caret-height,.375rem)}.cds--popover--tab-tip>.cds--popover>.cds--popover-content{border-radius:0}.cds--popover--tab-tip .cds--popover{will-change:filter}.cds--popover--tab-tip__button{align-items:center;-webkit-appearance:none;-moz-appearance:none;appearance:none;background:none;block-size:2rem;border:0;box-sizing:border-box;cursor:pointer;display:inline-block;display:inline-flex;font-family:inherit;font-size:100%;inline-size:100%;inline-size:2rem;justify-content:center;margin:0;padding:0;position:relative;text-align:start;vertical-align:baseline}.cds--popover--tab-tip__button *,.cds--popover--tab-tip__button :after,.cds--popover--tab-tip__button :before{box-sizing:inherit}.cds--popover--tab-tip__button::-moz-focus-inner{border:0}.cds--popover--tab-tip__button:focus{outline:2px solid var(--cds-focus,#0f62fe);outline-offset:-2px}@media screen and (prefers-contrast){.cds--popover--tab-tip__button:focus{outline-style:dotted}}.cds--popover--tab-tip__button:hover{background-color:var(--cds-layer-hover)}.cds--popover--tab-tip.cds--popover--open .cds--popover--tab-tip__button{background:var(--cds-layer);box-shadow:0 2px 2px rgba(0,0,0,.2)}.cds--popover--tab-tip.cds--popover--open .cds--popover--tab-tip__button:not(:focus):after{background:var(--cds-layer);block-size:2px;content:\"\";inline-size:100%;inset-block-end:0;position:absolute;z-index:6001}.cds--popover--tab-tip__button svg{fill:var(--cds-icon-primary,#161616)}.cds--tooltip{--cds-popover-offset:12px}.cds--tooltip-content{color:var(--cds-text-inverse,#fff);font-size:var(--cds-body-01-font-size,.875rem);font-weight:var(--cds-body-01-font-weight,400);letter-spacing:var(--cds-body-01-letter-spacing,.16px);line-height:var(--cds-body-01-line-height,1.42857);max-inline-size:18rem;padding:var(--cds-tooltip-padding-block,1rem) var(--cds-tooltip-padding-inline,1rem)}.cds--icon-tooltip{--cds-tooltip-padding-block:0.125rem;--cds-popover-caret-width:0.5rem;--cds-popover-caret-height:0.25rem;--cds-popover-offset:0.5rem}.cds--icon-tooltip .cds--tooltip-content{font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);line-height:var(--cds-body-compact-01-line-height,1.28572)}.cds--definition-term{-webkit-appearance:none;-moz-appearance:none;appearance:none;background:none;border:0;border-block-end:1px dotted var(--cds-border-strong);border-radius:0;box-sizing:border-box;color:var(--cds-text-primary,#161616);cursor:pointer;display:inline-block;font-family:inherit;font-size:100%;inline-size:100%;margin:0;padding:0;text-align:start;vertical-align:baseline}.cds--definition-term *,.cds--definition-term :after,.cds--definition-term :before{box-sizing:inherit}.cds--definition-term::-moz-focus-inner{border:0}.cds--definition-term:focus{border-block-end-color:var(--cds-border-interactive,#0f62fe);outline:1px solid var(--cds-focus,#0f62fe)}@media screen and (prefers-contrast){.cds--definition-term:focus{outline-style:dotted}}.cds--definition-term:hover{border-block-end-color:var(--cds-border-interactive,#0f62fe)}.cds--definition-tooltip{font-size:var(--cds-body-01-font-size,.875rem);font-weight:var(--cds-body-01-font-weight,400);letter-spacing:var(--cds-body-01-letter-spacing,.16px);line-height:var(--cds-body-01-line-height,1.42857);max-inline-size:11rem;padding:.5rem 1rem}.cds--btn{--cds-layout-size-height-local:clamp(max(var(--cds-layout-size-height-min),var(--cds-layout-size-height-sm)),var(--cds-layout-size-height,var(--cds-layout-size-height-lg)),min(var(--cds-layout-size-height-max),var(--cds-layout-size-height-2xl)));--cds-layout-density-padding-inline-local:clamp(var(--cds-layout-density-padding-inline-min),var(--cds-layout-density-padding-inline,var(--cds-layout-density-padding-inline-normal)),var(--cds-layout-density-padding-inline-max));--temp-1lh:(var(--cds-body-compact-01-line-height,1.28572) * 1em);--temp-expressive-1lh:(var(--cds-body-compact-02-line-height,1.375) * 1em);--temp-padding-block-max:calc((var(--cds-layout-size-height-lg) - var(--temp-1lh))/2 - 0.0625rem);border:0;border-radius:0;box-sizing:border-box;cursor:pointer;display:inline-flex;flex-shrink:0;font-family:inherit;font-size:100%;font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);inline-size:-moz-max-content;inline-size:max-content;justify-content:space-between;letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);line-height:var(--cds-body-compact-01-line-height,1.28572);margin:0;max-inline-size:20rem;min-block-size:var(--cds-layout-size-height-local);outline:none;padding:0;padding-block:min((var(--cds-layout-size-height-local) - var(--temp-1lh))/2 - .0625rem,var(--temp-padding-block-max));padding-inline:calc(var(--cds-layout-density-padding-inline-local) - .0625rem) calc(var(--cds-layout-density-padding-inline-local)*3 + .9375rem);position:relative;text-align:start;text-decoration:none;transition:background 70ms cubic-bezier(0,0,.38,.9),box-shadow 70ms cubic-bezier(0,0,.38,.9),border-color 70ms cubic-bezier(0,0,.38,.9),outline 70ms cubic-bezier(0,0,.38,.9);vertical-align:baseline;vertical-align:top}.cds--btn *,.cds--btn :after,.cds--btn :before{box-sizing:inherit}.cds--btn.cds--btn--disabled,.cds--btn.cds--btn--disabled:focus,.cds--btn.cds--btn--disabled:hover,.cds--btn:disabled,.cds--btn:focus:disabled,.cds--btn:hover:disabled{background:var(--cds-button-disabled,#c6c6c6);border-color:var(--cds-button-disabled,#c6c6c6);box-shadow:none;color:var(--cds-text-on-color-disabled,#8d8d8d);cursor:not-allowed}.cds--btn .cds--btn__icon,:host(cds-button) .cds--btn ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn ::slotted([slot=icon]){block-size:1rem;flex-shrink:0;inline-size:1rem;inset-block-start:min((var(--cds-layout-size-height-local) - 1rem)/2 - .0625rem,var(--temp-padding-block-max));inset-inline-end:var(--cds-layout-density-padding-inline-local);margin-block-start:.0625rem;position:absolute}.cds--btn::-moz-focus-inner{border:0;padding:0}.cds--btn--primary{background-color:var(--cds-button-primary,#0f62fe);border:1px solid transparent;color:var(--cds-text-on-color,#fff)}.cds--btn--primary:hover{background-color:var(--cds-button-primary-hover,#0050e6)}.cds--btn--primary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--primary:active{background-color:var(--cds-button-primary-active,#002d9c)}.cds--btn--primary .cds--btn__icon,.cds--btn--primary .cds--btn__icon path:not([data-icon-path]):not([fill=none]),:host(cds-button) .cds--btn--primary ::slotted([slot=icon]),:host(cds-button) .cds--btn--primary ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]),:host(cds-modal-footer-button) .cds--btn--primary ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--primary ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--primary:hover,.cds--btn--secondary{color:var(--cds-text-on-color,#fff)}.cds--btn--secondary{background-color:var(--cds-button-secondary,#393939);border:1px solid transparent}.cds--btn--secondary:hover{background-color:var(--cds-button-secondary-hover,#474747)}.cds--btn--secondary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--secondary:active{background-color:var(--cds-button-secondary-active,#6f6f6f)}.cds--btn--secondary .cds--btn__icon,.cds--btn--secondary .cds--btn__icon path:not([data-icon-path]):not([fill=none]),:host(cds-button) .cds--btn--secondary ::slotted([slot=icon]),:host(cds-button) .cds--btn--secondary ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]),:host(cds-modal-footer-button) .cds--btn--secondary ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--secondary ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--secondary:focus,.cds--btn--secondary:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--tertiary{background-color:transparent;border-color:var(--cds-button-tertiary,#0f62fe);border-style:solid;border-width:1px;color:var(--cds-button-tertiary,#0f62fe)}.cds--btn--tertiary:hover{background-color:var(--cds-button-tertiary-hover,#0050e6)}.cds--btn--tertiary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--tertiary .cds--btn__icon,.cds--btn--tertiary .cds--btn__icon path:not([data-icon-path]):not([fill=none]),:host(cds-button) .cds--btn--tertiary ::slotted([slot=icon]),:host(cds-button) .cds--btn--tertiary ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]),:host(cds-modal-footer-button) .cds--btn--tertiary ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--tertiary ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--tertiary:focus,.cds--btn--tertiary:hover{color:var(--cds-text-inverse,#fff)}.cds--btn--tertiary:focus{background-color:var(--cds-button-tertiary,#0f62fe)}.cds--btn--tertiary:active{background-color:var(--cds-button-tertiary-active,#002d9c);border-color:transparent;color:var(--cds-text-inverse,#fff)}.cds--btn--tertiary.cds--btn--disabled,.cds--btn--tertiary.cds--btn--disabled:focus,.cds--btn--tertiary.cds--btn--disabled:hover,.cds--btn--tertiary:disabled,.cds--btn--tertiary:focus:disabled,.cds--btn--tertiary:hover:disabled{background:transparent;color:var(--cds-text-on-color-disabled,#8d8d8d);outline:none}.cds--btn--ghost{background-color:transparent;border:1px solid transparent;color:var(--cds-link-primary,#0f62fe);padding-inline-end:calc(var(--cds-layout-density-padding-inline-local) - .0625rem)}.cds--btn--ghost:hover{background-color:var(--cds-background-hover,hsla(0,0%,55%,.12))}.cds--btn--ghost:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--ghost .cds--btn__icon,.cds--btn--ghost .cds--btn__icon path:not([data-icon-path]):not([fill=none]),:host(cds-button) .cds--btn--ghost ::slotted([slot=icon]),:host(cds-button) .cds--btn--ghost ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]),:host(cds-modal-footer-button) .cds--btn--ghost ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--ghost ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--ghost .cds--btn__icon,:host(cds-button) .cds--btn--ghost ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--ghost ::slotted([slot=icon]){align-self:center;margin-inline-start:.5rem;position:static}.cds--btn--ghost:active,.cds--btn--ghost:hover{color:var(--cds-link-primary-hover,#0043ce)}.cds--btn--ghost:active{background-color:var(--cds-background-active,hsla(0,0%,55%,.5))}.cds--btn--ghost.cds--btn--disabled,.cds--btn--ghost.cds--btn--disabled:focus,.cds--btn--ghost.cds--btn--disabled:hover,.cds--btn--ghost:disabled,.cds--btn--ghost:focus:disabled,.cds--btn--ghost:hover:disabled{background:transparent;border-color:transparent;color:var(--cds-text-on-color-disabled,#8d8d8d);outline:none}.cds--btn--ghost:not([disabled]) svg{fill:var(--cds-icon-primary,#161616)}.cds--btn--icon-only{block-size:var(--cds-layout-size-height-local);inline-size:var(--cds-layout-size-height-local);justify-content:center;padding:0;padding-block-start:min((var(--cds-layout-size-height-local) - 1rem)/2 - .0625rem,var(--temp-padding-block-max))}.cds--btn--icon-only>:first-child{min-inline-size:1rem}.cds--btn--icon-only .cds--btn__icon,:host(cds-button) .cds--btn--icon-only ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--icon-only ::slotted([slot=icon]){position:static}.cds--btn--icon-only.cds--btn--danger--ghost .cds--btn__icon,.cds--btn--icon-only.cds--btn--ghost .cds--btn__icon,:host(cds-button) .cds--btn--icon-only.cds--btn--danger--ghost ::slotted([slot=icon]),:host(cds-button) .cds--btn--icon-only.cds--btn--ghost ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--icon-only.cds--btn--danger--ghost ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--icon-only.cds--btn--ghost ::slotted([slot=icon]){margin:0}.cds--btn--icon-only.cds--btn--danger--ghost{padding-inline-end:calc(var(--cds-layout-density-padding-inline-local) - 1rem)}.cds--btn--md:not(.cds--btn--icon-only) .cds--btn__icon,.cds--btn--sm:not(.cds--btn--icon-only) .cds--btn__icon,:host(cds-button) .cds--btn--md:not(.cds--btn--icon-only) ::slotted([slot=icon]),:host(cds-button) .cds--btn--sm:not(.cds--btn--icon-only) ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--md:not(.cds--btn--icon-only) ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--sm:not(.cds--btn--icon-only) ::slotted([slot=icon]){margin-block-start:0}.cds--btn--icon-only.cds--btn--selected{background:var(--cds-background-selected,hsla(0,0%,55%,.2))}.cds--btn path[data-icon-path=inner-path]{fill:none}.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon,.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon path:not([data-icon-path]):not([fill=none]),:host(cds-button) .cds--btn--ghost.cds--btn--icon-only ::slotted([slot=icon]),:host(cds-button) .cds--btn--ghost.cds--btn--icon-only ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]),:host(cds-modal-footer-button) .cds--btn--ghost.cds--btn--icon-only ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--ghost.cds--btn--icon-only ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]){fill:var(--cds-icon-primary,#161616)}.cds--btn--ghost.cds--btn--icon-only[disabled] .cds--btn__icon,.cds--btn--ghost.cds--btn--icon-only[disabled] .cds--btn__icon path:not([data-icon-path]):not([fill=none]),.cds--btn.cds--btn--icon-only.cds--btn--ghost[disabled]:hover .cds--btn__icon,:host(cds-button) .cds--btn--ghost.cds--btn--icon-only[disabled] ::slotted([slot=icon]),:host(cds-button) .cds--btn--ghost.cds--btn--icon-only[disabled] ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]),:host(cds-modal-footer-button) .cds--btn--ghost.cds--btn--icon-only[disabled] ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--ghost.cds--btn--icon-only[disabled] ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]){fill:var(--cds-icon-on-color-disabled,#8d8d8d)}.cds--btn--ghost.cds--btn--icon-only[disabled],.cds--icon-tooltip--disabled .cds--tooltip-trigger__wrapper{cursor:not-allowed}.cds--icon-tooltip--disabled .cds--btn--icon-only[disabled]{pointer-events:none}.cds--btn--danger{background-color:var(--cds-button-danger-primary,#da1e28);border:1px solid transparent;color:var(--cds-text-on-color,#fff)}.cds--btn--danger:hover{background-color:var(--cds-button-danger-hover,#b81921)}.cds--btn--danger:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--danger:active{background-color:var(--cds-button-danger-active,#750e13)}.cds--btn--danger .cds--btn__icon,.cds--btn--danger .cds--btn__icon path:not([data-icon-path]):not([fill=none]),:host(cds-button) .cds--btn--danger ::slotted([slot=icon]),:host(cds-button) .cds--btn--danger ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]),:host(cds-modal-footer-button) .cds--btn--danger ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--danger ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--danger:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary{background-color:transparent;border-color:var(--cds-button-danger-secondary,#da1e28);border-style:solid;border-width:1px;color:var(--cds-button-danger-secondary,#da1e28)}.cds--btn--danger--tertiary:hover{background-color:var(--cds-button-danger-hover,#b81921)}.cds--btn--danger--tertiary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--danger--tertiary .cds--btn__icon,.cds--btn--danger--tertiary .cds--btn__icon path:not([data-icon-path]):not([fill=none]),:host(cds-button) .cds--btn--danger--tertiary ::slotted([slot=icon]),:host(cds-button) .cds--btn--danger--tertiary ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]),:host(cds-modal-footer-button) .cds--btn--danger--tertiary ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--danger--tertiary ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--danger--tertiary:hover{border-color:var(--cds-button-danger-hover,#b81921);color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary:focus{background-color:var(--cds-button-danger-primary,#da1e28);color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary:active{background-color:var(--cds-button-danger-active,#750e13);border-color:var(--cds-button-danger-active,#750e13);color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary.cds--btn--disabled,.cds--btn--danger--tertiary.cds--btn--disabled:focus,.cds--btn--danger--tertiary.cds--btn--disabled:hover,.cds--btn--danger--tertiary:disabled,.cds--btn--danger--tertiary:focus:disabled,.cds--btn--danger--tertiary:hover:disabled{background:transparent;color:var(--cds-text-on-color-disabled,#8d8d8d);outline:none}.cds--btn--danger--ghost{background-color:transparent;border:1px solid transparent;color:var(--cds-button-danger-secondary,#da1e28);padding-inline-end:calc(var(--cds-layout-density-padding-inline-local) - .0625rem)}.cds--btn--danger--ghost:hover{background-color:var(--cds-button-danger-hover,#b81921)}.cds--btn--danger--ghost:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--danger--ghost:active{background-color:var(--cds-button-danger-active,#750e13)}.cds--btn--danger--ghost .cds--btn__icon,.cds--btn--danger--ghost .cds--btn__icon path:not([data-icon-path]):not([fill=none]),:host(cds-button) .cds--btn--danger--ghost ::slotted([slot=icon]),:host(cds-button) .cds--btn--danger--ghost ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]),:host(cds-modal-footer-button) .cds--btn--danger--ghost ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--danger--ghost ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--danger--ghost .cds--btn__icon,:host(cds-button) .cds--btn--danger--ghost ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--danger--ghost ::slotted([slot=icon]){margin-inline-start:.5rem;position:static}.cds--btn--danger--ghost:active,.cds--btn--danger--ghost:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--danger--ghost.cds--btn--disabled,.cds--btn--danger--ghost.cds--btn--disabled:focus,.cds--btn--danger--ghost.cds--btn--disabled:hover,.cds--btn--danger--ghost:disabled,.cds--btn--danger--ghost:focus:disabled,.cds--btn--danger--ghost:hover:disabled{background:transparent;border-color:transparent;color:var(--cds-text-disabled,hsla(0,0%,9%,.25));outline:none}.cds--btn--expressive{font-size:var(--cds-body-compact-02-font-size,1rem);font-weight:var(--cds-body-compact-02-font-weight,400);letter-spacing:var(--cds-body-compact-02-letter-spacing,0);line-height:var(--cds-body-compact-02-line-height,1.375);padding-block:min((var(--cds-layout-size-height-local) - var(--temp-expressive-1lh))/2 - .0625rem,var(--temp-padding-block-max))}.cds--btn--icon-only.cds--btn--expressive{padding:12px 13px}.cds--btn.cds--btn--expressive .cds--btn__icon,:host(cds-button) .cds--btn.cds--btn--expressive ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn.cds--btn--expressive ::slotted([slot=icon]){block-size:1.25rem;inline-size:1.25rem}.cds--btn-set .cds--btn.cds--btn--expressive,:host(cds-button-set) .cds--btn.cds--btn--expressive,:host(cds-side-panel-button-set) .cds--btn.cds--btn--expressive{max-inline-size:20rem}.cds--btn.cds--skeleton{background:var(--cds-skeleton-background,#e8e8e8);border:none;box-shadow:none;inline-size:9.375rem;padding:0;pointer-events:none;position:relative}.cds--btn.cds--skeleton:active,.cds--btn.cds--skeleton:focus,.cds--btn.cds--skeleton:hover{border:none;cursor:default;outline:none}.cds--btn.cds--skeleton:before{animation:cds--skeleton 3s ease-in-out infinite;background:var(--cds-skeleton-element,#c6c6c6);block-size:100%;content:\"\";inline-size:100%;inset-inline-start:0;position:absolute;will-change:transform-origin,transform,opacity}@media (prefers-reduced-motion:reduce){.cds--btn.cds--skeleton:before{animation:none}}.cds--btn-set,:host(cds-button-set),:host(cds-side-panel-button-set){display:flex}.cds--btn-set--stacked,:host(cds-button-set[stacked]){flex-direction:column}.cds--btn-set .cds--btn,:host(cds-button-set) .cds--btn,:host(cds-side-panel-button-set) .cds--btn{inline-size:100%;max-inline-size:12.25rem}.cds--btn-set .cds--btn:not(:focus),:host(cds-button-set) .cds--btn:not(:focus),:host(cds-side-panel-button-set) .cds--btn:not(:focus){box-shadow:-.0625rem 0 0 0 var(--cds-button-separator,#e0e0e0)}.cds--btn-set .cds--btn:first-of-type:not(:focus),:host(cds-button-set) .cds--btn:first-of-type:not(:focus),:host(cds-side-panel-button-set) .cds--btn:first-of-type:not(:focus){box-shadow:inherit}.cds--btn-set .cds--btn:focus+.cds--btn,:host(cds-button-set) .cds--btn:focus+.cds--btn,:host(cds-side-panel-button-set) .cds--btn:focus+.cds--btn{box-shadow:inherit}.cds--btn-set--stacked .cds--btn:not(:focus),:host(cds-button-set[stacked]) .cds--btn:not(:focus){box-shadow:0 -.0625rem 0 0 var(--cds-button-separator,#e0e0e0)}.cds--btn-set--stacked .cds--btn:first-of-type:not(:focus),:host(cds-button-set[stacked]) .cds--btn:first-of-type:not(:focus){box-shadow:inherit}.cds--btn-set .cds--btn.cds--btn--disabled,:host(cds-button-set) .cds--btn.cds--btn--disabled,:host(cds-side-panel-button-set) .cds--btn.cds--btn--disabled{box-shadow:-.0625rem 0 0 0 var(--cds-icon-on-color-disabled,#8d8d8d)}.cds--btn-set .cds--btn.cds--btn--disabled:first-of-type,:host(cds-button-set) .cds--btn.cds--btn--disabled:first-of-type,:host(cds-side-panel-button-set) .cds--btn.cds--btn--disabled:first-of-type{box-shadow:none}.cds--btn-set--stacked .cds--btn.cds--btn--disabled,:host(cds-button-set[stacked]) .cds--btn.cds--btn--disabled{box-shadow:0 -.0625rem 0 0 var(--cds-layer-selected-disabled,#8d8d8d)}.cds--btn-set--stacked .cds--btn.cds--btn--disabled:first-of-type,:host(cds-button-set[stacked]) .cds--btn.cds--btn--disabled:first-of-type{box-shadow:none}.cds--btn-set .cds--btn.cds--btn--loading,:host(cds-button-set) .cds--btn.cds--btn--loading,:host(cds-side-panel-button-set) .cds--btn.cds--btn--loading{background-color:transparent;border-color:transparent;box-shadow:none}@media (forced-colors:active),screen and (-ms-high-contrast:active){.cds--btn:focus{color:Highlight;outline:1px solid Highlight}}@media (forced-colors:active),screen and (-ms-high-contrast:active){.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon,.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon path:not([data-icon-path]):not([fill=none]),:host(cds-button) .cds--btn--ghost.cds--btn--icon-only ::slotted([slot=icon]),:host(cds-button) .cds--btn--ghost.cds--btn--icon-only ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]),:host(cds-modal-footer-button) .cds--btn--ghost.cds--btn--icon-only ::slotted([slot=icon]),:host(cds-modal-footer-button) .cds--btn--ghost.cds--btn--icon-only ::slotted([slot=icon]) path:not([data-icon-path]):not([fill=none]){fill:ButtonText}}[dir=rtl] .cds--btn-set .cds--btn:not(:focus),[dir=rtl] :host(cds-button-set) .cds--btn:not(:focus),[dir=rtl] :host(cds-side-panel-button-set) .cds--btn:not(:focus){box-shadow:.0625rem 0 0 0 var(--cds-button-separator,#e0e0e0)}.cds--copy-btn{position:relative}.cds--copy-btn:hover{background-color:var(--cds-layer-hover)}.cds--copy-btn:active{background-color:var(--cds-layer-active)}.cds--copy-btn:before{block-size:0;border-style:solid;content:\"\";display:none;inline-size:0;position:absolute;z-index:6000}.cds--copy-btn .cds--copy-btn__feedback{background-color:var(--cds-background-inverse,#393939);block-size:auto;border-radius:.125rem;box-shadow:0 2px 6px var(--cds-shadow,rgba(0,0,0,.3));box-sizing:content-box;color:var(--cds-text-inverse,#fff);display:none;font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:400;font-weight:var(--cds-body-compact-01-font-weight,400);inline-size:-moz-max-content;inline-size:max-content;letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);line-height:var(--cds-body-compact-01-line-height,1.28572);margin:auto;max-inline-size:13rem;min-inline-size:1.5rem;overflow:visible;padding:.1875rem 1rem;text-align:start;transform:translateX(-50%);z-index:6000;clip:auto}@media (-ms-high-contrast:active),(-ms-high-contrast:none){.cds--copy-btn .cds--copy-btn__feedback{inline-size:auto}}@supports (-ms-accelerator:true){.cds--copy-btn .cds--copy-btn__feedback{inline-size:auto}}@supports (-ms-ime-align:auto){.cds--copy-btn .cds--copy-btn__feedback{inline-size:auto}}@media screen and (-ms-high-contrast:active),screen and (prefers-contrast){.cds--copy-btn .cds--copy-btn__feedback{border:1px solid transparent}}.cds--copy-btn.cds--copy-btn--animating .cds--copy-btn__feedback,.cds--copy-btn.cds--copy-btn--animating:before{display:block}.cds--copy-btn.cds--copy-btn--animating:before{border:none}.cds--copy-btn.cds--copy-btn--animating.cds--copy-btn--fade-out .cds--copy-btn__feedback,.cds--copy-btn.cds--copy-btn--animating.cds--copy-btn--fade-out:before{animation:cds--hide-feedback .11s cubic-bezier(.2,0,.38,.9)}.cds--copy-btn.cds--copy-btn--animating.cds--copy-btn--fade-in .cds--copy-btn__feedback,.cds--copy-btn.cds--copy-btn--animating.cds--copy-btn--fade-in:before{animation:cds--show-feedback .11s cubic-bezier(.2,0,.38,.9)}.cds--copy-btn svg{fill:var(--cds-icon-primary,#161616)}.cds--copy{font-size:0}.cds--chat-btn{border-radius:1.5rem}.cds--chat-btn:not(.cds--chat-btn--with-icon){padding-inline-end:.9375rem}.cds--chat-btn.cds--btn--md{border-radius:1.25rem}.cds--chat-btn.cds--btn--sm{border-radius:1rem}.cds--chat-btn--quick-action{align-items:center;background:transparent;border:1px solid var(--cds-chat-button,#0f62fe);color:var(--cds-chat-button,#0f62fe)}.cds--chat-btn--quick-action:hover:not(:active):not([disabled]){background:var(--cds-chat-button-hover,hsla(0,0%,55%,.12));border-color:transparent;color:var(--cds-chat-button-text-hover,#0043ce)}.cds--chat-btn--quick-action:active{background:var(--cds-chat-button-active,hsla(0,0%,55%,.5));border-color:transparent;color:var(--cds-chat-button-text-hover,#0043ce)}.cds--chat-btn--quick-action.cds--btn--ghost:focus{border-color:var(--cds-focus,#0f62fe);box-shadow:inset 0 0 0 1px var(--cds-focus,#0f62fe)}.cds--chat-btn--quick-action.cds--btn--ghost:hover:focus{border-color:var(--cds-focus,#0f62fe);box-shadow:inset 0 0 0 1px var(--cds-focus-inset,#fff)}.cds--chat-btn--quick-action[disabled],.cds--chat-btn--quick-action[disabled]:hover{border-color:var(--cds-button-disabled,#c6c6c6);color:var(--cds-button-disabled,#c6c6c6)}.cds--chat-btn--quick-action--selected,.cds--chat-btn--quick-action--selected[disabled],.cds--chat-btn--quick-action--selected[disabled]:hover{background:var(--cds-chat-button-selected,hsla(0,0%,55%,.2));border-color:transparent;color:var(--cds-chat-button-text-selected,#525252)}.cds--chat-btn--quick-action.cds--chat-btn--quick-action--selected:not([disabled]):active,.cds--chat-btn--quick-action.cds--chat-btn--quick-action--selected:not([disabled]):hover{color:var(--cds-chat-button-text-selected,#525252)}.cds--chat-btn.cds--skeleton{overflow:hidden}.cds--snippet html{font-size:100%}.cds--snippet body{font-family:IBM Plex Sans,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,sans-serif;font-weight:400;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;text-rendering:optimizeLegibility}.cds--snippet code{font-family:IBM Plex Mono,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,monospace}.cds--snippet strong{font-weight:600}.cds--snippet--disabled,.cds--snippet--disabled .cds--btn.cds--snippet-btn--expand{background-color:var(--cds-layer);color:var(--cds-text-disabled,hsla(0,0%,9%,.25))}.cds--snippet--disabled .cds--copy-btn,.cds--snippet--disabled .cds--copy-btn:hover,.cds--snippet--disabled .cds--snippet-btn--expand:hover{background-color:var(--cds-layer);color:var(--cds-text-disabled,hsla(0,0%,9%,.25));cursor:not-allowed}.cds--snippet--disabled .cds--snippet-btn--expand .cds--icon-chevron--down,.cds--snippet--disabled .cds--snippet__icon{fill:var(--cds-icon-disabled,hsla(0,0%,9%,.25))}.cds--snippet code{font-family:var(--cds-code-01-font-family,\"IBM Plex Mono\",system-ui,-apple-system,BlinkMacSystemFont,\".SFNSText-Regular\",monospace);font-size:var(--cds-code-01-font-size,.75rem);font-weight:var(--cds-code-01-font-weight,400);letter-spacing:var(--cds-code-01-letter-spacing,.32px);line-height:var(--cds-code-01-line-height,1.33333)}.cds--snippet--inline{background-color:var(--cds-layer);border:1px solid transparent;border-radius:4px;color:var(--cds-text-primary,#161616);cursor:pointer;display:inline;padding:0;position:relative}.cds--snippet--inline html{font-size:100%}.cds--snippet--inline body{font-family:IBM Plex Sans,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,sans-serif;font-weight:400;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;text-rendering:optimizeLegibility}.cds--snippet--inline code{font-family:IBM Plex Mono,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,monospace}.cds--snippet--inline strong{font-weight:600}.cds--snippet--inline:hover{background-color:var(--cds-layer-hover)}.cds--snippet--inline:active{background-color:var(--cds-layer-active)}.cds--snippet--inline:focus{border:1px solid var(--cds-focus,#0f62fe);outline:none}.cds--snippet--inline:before{block-size:0;border:none;content:\"\";display:none;inline-size:0;position:absolute;z-index:6000}.cds--snippet--inline .cds--copy-btn__feedback{background-color:var(--cds-background-inverse,#393939);block-size:auto;border-radius:.125rem;box-shadow:0 2px 6px var(--cds-shadow,rgba(0,0,0,.3));box-sizing:content-box;color:var(--cds-text-inverse,#fff);display:none;font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:400;font-weight:var(--cds-body-compact-01-font-weight,400);inline-size:-moz-max-content;inline-size:max-content;letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);line-height:var(--cds-body-compact-01-line-height,1.28572);margin:auto;max-inline-size:13rem;min-inline-size:1.5rem;overflow:visible;padding:.1875rem 1rem;text-align:start;transform:translateX(-50%);z-index:6000;clip:auto}@media (-ms-high-contrast:active),(-ms-high-contrast:none){.cds--snippet--inline .cds--copy-btn__feedback{inline-size:auto}}@supports (-ms-accelerator:true){.cds--snippet--inline .cds--copy-btn__feedback{inline-size:auto}}@supports (-ms-ime-align:auto){.cds--snippet--inline .cds--copy-btn__feedback{inline-size:auto}}@media screen and (-ms-high-contrast:active),screen and (prefers-contrast){.cds--snippet--inline .cds--copy-btn__feedback{border:1px solid transparent}}.cds--snippet--inline.cds--copy-btn--animating .cds--copy-btn__feedback,.cds--snippet--inline.cds--copy-btn--animating:before{display:block}.cds--snippet--inline.cds--copy-btn--animating.cds--copy-btn--fade-out .cds--copy-btn__feedback,.cds--snippet--inline.cds--copy-btn--animating.cds--copy-btn--fade-out:before{animation:cds--hide-feedback .11s cubic-bezier(.2,0,.38,.9)}.cds--snippet--inline.cds--copy-btn--animating.cds--copy-btn--fade-in .cds--copy-btn__feedback,.cds--snippet--inline.cds--copy-btn--animating.cds--copy-btn--fade-in:before{animation:cds--show-feedback .11s cubic-bezier(.2,0,.38,.9)}.cds--snippet--inline code{padding:0 .5rem}.cds--snippet--inline.cds--snippet--no-copy{display:inline-block}.cds--snippet--inline.cds--snippet--no-copy:hover{background-color:var(--cds-layer);cursor:auto}.cds--snippet--light.cds--snippet--inline.cds--snippet--no-copy:hover{background-color:var(--cds-layer-hover);cursor:auto}.cds--snippet--single{align-items:center;background-color:var(--cds-layer);block-size:2.5rem;display:flex;font-family:var(--cds-code-01-font-family,\"IBM Plex Mono\",system-ui,-apple-system,BlinkMacSystemFont,\".SFNSText-Regular\",monospace);font-size:var(--cds-code-01-font-size,.75rem);font-weight:var(--cds-code-01-font-weight,400);inline-size:100%;letter-spacing:var(--cds-code-01-letter-spacing,.32px);line-height:var(--cds-code-01-line-height,1.33333);max-inline-size:48rem;padding-inline-end:2.5rem;position:relative}.cds--snippet--single.cds--snippet--no-copy{padding:0}.cds--snippet--single.cds--snippet--no-copy:after{inset-inline-end:1rem}.cds--snippet--single .cds--snippet-container{align-items:center;block-size:100%;display:flex;overflow-x:auto;padding-inline-start:1rem;position:relative}.cds--snippet--single .cds--snippet-container:focus{outline:2px solid var(--cds-focus,#0f62fe);outline-offset:-2px}@media screen and (prefers-contrast){.cds--snippet--single .cds--snippet-container:focus{outline-style:dotted}}.cds--snippet--single pre{font-family:var(--cds-code-01-font-family,\"IBM Plex Mono\",system-ui,-apple-system,BlinkMacSystemFont,\".SFNSText-Regular\",monospace);font-size:var(--cds-code-01-font-size,.75rem);font-weight:var(--cds-code-01-font-weight,400);letter-spacing:var(--cds-code-01-letter-spacing,.32px);line-height:var(--cds-code-01-line-height,1.33333);padding-inline-end:.5rem}.cds--snippet--inline code,.cds--snippet--single pre{white-space:pre}.cds--snippet--multi{background-color:var(--cds-layer);display:flex;font-family:var(--cds-code-01-font-family,\"IBM Plex Mono\",system-ui,-apple-system,BlinkMacSystemFont,\".SFNSText-Regular\",monospace);font-size:var(--cds-code-01-font-size,.75rem);font-weight:var(--cds-code-01-font-weight,400);inline-size:100%;letter-spacing:var(--cds-code-01-letter-spacing,.32px);line-height:var(--cds-code-01-line-height,1.33333);max-inline-size:48rem;padding:1rem;position:relative}.cds--snippet--multi .cds--snippet-container{max-block-size:100%;min-block-size:100%;order:1;overflow-y:auto;position:relative;transition:max-height .15s cubic-bezier(.2,0,.38,.9)}.cds--snippet--multi .cds--snippet-container:focus{outline:2px solid var(--cds-focus,#0f62fe);outline-offset:-2px;outline-offset:0}@media screen and (prefers-contrast){.cds--snippet--multi .cds--snippet-container:focus{outline-style:dotted}}.cds--snippet--multi.cds--snippet--expand .cds--snippet-container{padding-block-end:1rem;transition:max-height .15s cubic-bezier(.2,0,.38,.9)}.cds--snippet--multi.cds--snippet--wraptext pre{white-space:pre-wrap;word-wrap:break-word}.cds--snippet--multi .cds--snippet-container pre{padding-inline-end:2.5rem}.cds--snippet--multi.cds--snippet--no-copy .cds--snippet-container pre{padding-inline-end:0}.cds--snippet--multi.cds--snippet--has-right-overflow:after{background-image:linear-gradient(to right,transparent,var(--cds-layer));block-size:100%;content:\"\";inline-size:1rem;inset-block-start:0;inset-inline-end:1rem;position:absolute}[dir=rtl] .cds--snippet--multi.cds--snippet--has-right-overflow:after{background-image:linear-gradient(to left,transparent,var(--cds-layer))}.cds--snippet--multi .cds--snippet-container pre code{overflow:hidden}.cds--snippet__icon{block-size:1rem;fill:var(--cds-icon-primary,#161616);inline-size:1rem;transition:all 70ms cubic-bezier(.2,0,.38,.9)}.cds--btn>.cds--snippet__icon{margin-block-start:0}.cds--copy-btn{align-items:center;background-color:var(--cds-layer);border:none;cursor:pointer;display:flex;justify-content:center;outline:none;overflow:visible;padding:0}.cds--copy-btn html{font-size:100%}.cds--copy-btn body{font-family:IBM Plex Sans,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,sans-serif;font-weight:400;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;text-rendering:optimizeLegibility}.cds--copy-btn code{font-family:IBM Plex Mono,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,monospace}.cds--copy-btn strong{font-weight:600}.cds--copy-btn:focus{outline:2px solid var(--cds-focus,#0f62fe);outline-color:var(--cds-focus,#0f62fe);outline-offset:-2px}@media screen and (prefers-contrast){.cds--copy-btn:focus{outline-style:dotted}}.cds--snippet .cds--popover-container{font-family:IBM Plex Sans,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,sans-serif;inset-block-start:0;inset-inline-end:0;position:absolute}.cds--snippet--inline.cds--btn{block-size:1.25rem;inline-size:auto;max-inline-size:unset;min-block-size:1.25rem;padding-inline:0}.cds--snippet--inline.cds--btn.cds--btn--primary:hover{color:var(--cds-text-primary,#161616)}.cds--snippet.cds--snippet--multi .cds--popover-container{inset-block-start:.5rem;inset-inline-end:.5rem}.cds--snippet--multi .cds--copy-btn{z-index:10}.cds--snippet-btn--expand{align-items:center;background-color:var(--cds-layer);block-size:2rem;border:0;color:var(--cds-text-primary,#161616);display:inline-flex;font-family:IBM Plex Sans,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,sans-serif;font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);inset-block-end:0;inset-inline-end:0;letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);line-height:var(--cds-body-compact-01-line-height,1.28572);padding:.5rem 1rem;position:absolute;z-index:10}.cds--snippet-btn--expand .cds--snippet-btn--text{inset-block-start:-.0625rem;position:relative}.cds--snippet-btn--expand--hide.cds--snippet-btn--expand{display:none}.cds--snippet-btn--expand .cds--icon-chevron--down{fill:var(--cds-icon-primary,#161616);margin-inline-start:.5rem;transform:rotate(0deg);transition:.15s cubic-bezier(.2,0,.38,.9)}.cds--snippet-btn--expand:hover{background:var(--cds-layer-hover);color:var(--cds-text-primary,#161616)}.cds--snippet-btn--expand:active{background-color:var(--cds-layer-active)}.cds--snippet-btn--expand:focus{border-color:transparent;outline:2px solid var(--cds-focus,#0f62fe);outline-offset:-2px}@media screen and (prefers-contrast){.cds--snippet-btn--expand:focus{outline-style:dotted}}.cds--snippet--expand .cds--snippet-btn--expand .cds--icon-chevron--down{transform:rotate(180deg);transition:transform .3s}.cds--snippet--light,.cds--snippet--light .cds--btn.cds--snippet-btn--expand,.cds--snippet--light .cds--copy-btn,.cds--snippet--light .cds--snippet-button{background-color:var(--cds-layer)}.cds--snippet--light .cds--btn.cds--snippet-btn--expand:hover,.cds--snippet--light .cds--copy-btn:hover,.cds--snippet--light .cds--snippet-button:hover,.cds--snippet--light.cds--snippet--inline:hover{background-color:var(--cds-layer-hover)}.cds--snippet--light .cds--btn.cds--snippet-btn--expand:active,.cds--snippet--light .cds--copy-btn:active,.cds--snippet--light .cds--snippet-button:active,.cds--snippet--light.cds--snippet--inline:active{background-color:var(--cds-layer-active)}.cds--snippet--light.cds--snippet--multi:after,.cds--snippet--light.cds--snippet--single:after{background-image:linear-gradient(to right,rgba(var(--cds-layer),0),var(--cds-layer))}.cds--snippet.cds--skeleton .cds--snippet-container{block-size:100%;inline-size:100%}.cds--snippet-button .cds--btn--copy__feedback{inset-block-start:3.175rem;inset-inline:50% auto}.cds--snippet-button .cds--btn--copy__feedback:before{inset-block-start:0}.cds--snippet-button .cds--btn--copy__feedback:after{inset-block-start:-.25rem}.cds--snippet--multi .cds--snippet-button .cds--btn--copy__feedback{inset-block-start:2.675rem}.cds--snippet--inline .cds--btn--copy__feedback{inset-block-start:calc(100% - .25rem);inset-inline:50% auto}.cds--snippet__overflow-indicator--left,.cds--snippet__overflow-indicator--right{flex:1 0 auto;inline-size:1rem;z-index:1}.cds--snippet__overflow-indicator--left{background-image:linear-gradient(to left,transparent,var(--cds-layer));margin-inline-end:-1rem;order:0}.cds--snippet__overflow-indicator--right{margin-inline-start:-1rem;order:2}.cds--snippet__overflow-indicator--right,[dir=rtl] .cds--snippet__overflow-indicator--left{background-image:linear-gradient(to right,transparent,var(--cds-layer))}[dir=rtl] .cds--snippet__overflow-indicator--right{background-image:linear-gradient(to left,transparent,var(--cds-layer))}.cds--snippet--single .cds--snippet__overflow-indicator--left,.cds--snippet--single .cds--snippet__overflow-indicator--right{block-size:calc(100% - .25rem);inline-size:2rem;position:absolute}.cds--snippet--single .cds--snippet__overflow-indicator--right{inset-inline-end:2.5rem}.cds--snippet--single.cds--snippet--no-copy .cds--snippet__overflow-indicator--right{inset-inline-end:0}.cds--snippet--single .cds--snippet-container:focus~.cds--snippet__overflow-indicator--right{inset-inline-end:2.625rem}.cds--snippet--single .cds--snippet-container:focus+.cds--snippet__overflow-indicator--left{inset-inline-start:.125rem}.cds--snippet--light .cds--snippet__overflow-indicator--left{background-image:linear-gradient(to left,transparent,var(--cds-layer))}.cds--snippet--light .cds--snippet__overflow-indicator--right{background-image:linear-gradient(to right,transparent,var(--cds-layer))}@media not all and (min-resolution >= 0.001dpcm){@supports (-webkit-appearance:none) and (stroke-color:transparent){.cds--snippet__overflow-indicator--left{background-image:linear-gradient(to left,rgba(var(--cds-layer),0),var(--cds-layer))}.cds--snippet__overflow-indicator--right{background-image:linear-gradient(to right,rgba(var(--cds-layer),0),var(--cds-layer))}}}.cds--snippet--multi.cds--skeleton{block-size:6.125rem}.cds--snippet--single.cds--skeleton{block-size:3.5rem}.cds--snippet.cds--skeleton span{background:var(--cds-skeleton-background,#e8e8e8);block-size:1rem;border:none;box-shadow:none;display:block;inline-size:100%;margin-block-start:.5rem;padding:0;pointer-events:none;position:relative}.cds--snippet.cds--skeleton span:active,.cds--snippet.cds--skeleton span:focus,.cds--snippet.cds--skeleton span:hover{border:none;cursor:default;outline:none}.cds--snippet.cds--skeleton span:before{animation:cds--skeleton 3s ease-in-out infinite;background:var(--cds-skeleton-element,#c6c6c6);block-size:100%;content:\"\";inline-size:100%;inset-inline-start:0;position:absolute;will-change:transform-origin,transform,opacity}@media (prefers-reduced-motion:reduce){.cds--snippet.cds--skeleton span:before{animation:none}}.cds--snippet.cds--skeleton span:first-child{margin:0}.cds--snippet.cds--skeleton span:nth-child(2){inline-size:85%}.cds--snippet.cds--skeleton span:nth-child(3){inline-size:95%}.cds--snippet--single.cds--skeleton .cds--snippet-container{padding-block-end:0}@media (forced-colors:active),screen and (-ms-high-contrast:active){.cds--snippet__icon{fill:ButtonText}.cds--snippet--inline:focus{color:Highlight;outline:1px solid Highlight}.cds--snippet--multi,.cds--snippet--single{outline:1px solid transparent}}:host(cds-button),:host(cds-modal-footer-button){--cds-layout-size-height-xs:1.5rem;--cds-layout-size-height-sm:2rem;--cds-layout-size-height-md:2.5rem;--cds-layout-size-height-lg:3rem;--cds-layout-size-height-xl:4rem;--cds-layout-size-height-2xl:5rem;--cds-layout-size-height-min:0px;--cds-layout-size-height-max:999999999px;--cds-layout-density-padding-inline-condensed:0.5rem;--cds-layout-density-padding-inline-normal:1rem;--cds-layout-density-padding-inline-min:0px;--cds-layout-density-padding-inline-max:999999999px;display:inline-flex}:host(cds-button) .cds--btn,:host(cds-modal-footer-button) .cds--btn{flex-grow:1;max-inline-size:100%}:host(cds-button-skeleton){--cds-layout-size-height-xs:1.5rem;--cds-layout-size-height-sm:2rem;--cds-layout-size-height-md:2.5rem;--cds-layout-size-height-lg:3rem;--cds-layout-size-height-xl:4rem;--cds-layout-size-height-2xl:5rem;--cds-layout-size-height-min:0px;--cds-layout-size-height-max:999999999px;--cds-layout-density-padding-inline-condensed:0.5rem;--cds-layout-density-padding-inline-normal:1rem;--cds-layout-density-padding-inline-min:0px;--cds-layout-density-padding-inline-max:999999999px}:host(cds-button[isExpressive]) ::slotted([slot=icon]),:host(cds-modal-footer-button[isExpressive]) ::slotted([slot=icon]){block-size:1.25rem;inline-size:1.25rem}:host(cds-button[pagination]) .cds--btn,:host(cds-modal-footer-button[pagination]) .cds--btn{border:none;border-inline-start:1px solid var(--cds-border-subtle);padding:0;transition:none}:host(cds-button[pagination]) .cds--btn:focus,:host(cds-modal-footer-button[pagination]) .cds--btn:focus{border-inline-start:1px solid transparent;box-shadow:none;outline:.125rem solid var(--cds-focus,#0f62fe);outline-offset:-.125rem}:host(cds-button[pagination]:not([disabled])) .cds--btn,:host(cds-modal-footer-button[pagination]:not([disabled])) .cds--btn{color:var(--cds-icon-primary,#161616)}:host(cds-button[pagination]:not([disabled])) .cds--btn:active,:host(cds-modal-footer-button[pagination]:not([disabled])) .cds--btn:active{background-color:var(--cds-layer-hover)}:host(cds-button[pagination][batch-action]:not([disabled])) .cds--btn,:host(cds-modal-footer-button[pagination][batch-action]:not([disabled])) .cds--btn{padding:calc(.875rem - 3px) 1rem}:host(cds-button[pagination][batch-action]:not([disabled])) .cds--btn:focus,:host(cds-modal-footer-button[pagination][batch-action]:not([disabled])) .cds--btn:focus{outline:.125rem solid var(--cds-layer);outline-offset:-.125rem}:host(cds-button[pagination][batch-action]:not([disabled])) :host(cds-button[pagination][has-main-content]:not([disabled])) ::slotted([slot=icon]),:host(cds-button[pagination][batch-action]:not([disabled])) :host(cds-modal-footer-button[pagination][has-main-content]:not([disabled])) ::slotted([slot=icon]),:host(cds-modal-footer-button[pagination][batch-action]:not([disabled])) :host(cds-button[pagination][has-main-content]:not([disabled])) ::slotted([slot=icon]),:host(cds-modal-footer-button[pagination][batch-action]:not([disabled])) :host(cds-modal-footer-button[pagination][has-main-content]:not([disabled])) ::slotted([slot=icon]){margin-inline-start:.25rem;position:static}:host(cds-button[kind=ghost]) .cds--btn--ghost:active,:host(cds-button[kind=ghost]:hover) .cds--btn--ghost{outline:none}:host(cds-button-set) ::slotted(cds-button),:host(cds-side-panel-button-set) ::slotted(cds-button){inline-size:100%;max-inline-size:12.25rem}"]);

export { buttonStyles as default };
//# sourceMappingURL=button.scss.js.map
