/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2022, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Button kind.
 */
var BUTTON_KIND;
(function (BUTTON_KIND) {
    /**
     * Primary button.
     */
    BUTTON_KIND["PRIMARY"] = "primary";
    /**
     * Secondary button.
     */
    BUTTON_KIND["SECONDARY"] = "secondary";
    /**
     * Tertiary button.
     */
    BUTTON_KIND["TERTIARY"] = "tertiary";
    /**
     * Ghost button.
     */
    BUTTON_KIND["GHOST"] = "ghost";
    /**
     * Danger button.
     */
    BUTTON_KIND["DANGER"] = "danger";
    /**
     * @deprecated use 'danger' kind
     * Danger primary button.
     */
    BUTTON_KIND["DANGER_PRIMARY"] = "danger-primary";
    /**
     * Danger tertiary button.
     */
    BUTTON_KIND["DANGER_TERTIARY"] = "danger-tertiary";
    /**
     * Danger ghost button,
     */
    BUTTON_KIND["DANGER_GHOST"] = "danger-ghost";
})(BUTTON_KIND || (BUTTON_KIND = {}));
/**
 * Button type.
 */
var BUTTON_TYPE;
(function (BUTTON_TYPE) {
    /**
     * Default button type.
     */
    BUTTON_TYPE["BUTTON"] = "button";
    /**
     * Reset button type.
     */
    BUTTON_TYPE["RESET"] = "reset";
    /**
     * Submit button type.
     */
    BUTTON_TYPE["SUBMIT"] = "submit";
})(BUTTON_TYPE || (BUTTON_TYPE = {}));
/**
 * Button size.
 */
var BUTTON_SIZE;
(function (BUTTON_SIZE) {
    /**
     * Small size.
     */
    BUTTON_SIZE["SMALL"] = "sm";
    /**
     * Medium size.
     */
    BUTTON_SIZE["MEDIUM"] = "md";
    /**
     * Large size.
     */
    BUTTON_SIZE["LARGE"] = "lg";
    /**
     * X-Large size.
     */
    BUTTON_SIZE["EXTRA_LARGE"] = "xl";
    /**
     * 2X-Large size.
     */
    BUTTON_SIZE["EXTRA_EXTRA_LARGE"] = "2xl";
})(BUTTON_SIZE || (BUTTON_SIZE = {}));
/**
 * Button tooltip alignment.
 */
var BUTTON_TOOLTIP_ALIGNMENT;
(function (BUTTON_TOOLTIP_ALIGNMENT) {
    /**
     * Aligned to the start.
     */
    BUTTON_TOOLTIP_ALIGNMENT["START"] = "left";
    /**
     * Aligned to the center.
     */
    BUTTON_TOOLTIP_ALIGNMENT["CENTER"] = "";
    /**
     * Aligned to the end.
     */
    BUTTON_TOOLTIP_ALIGNMENT["END"] = "right";
})(BUTTON_TOOLTIP_ALIGNMENT || (BUTTON_TOOLTIP_ALIGNMENT = {}));
/**
 * Button tooltip position.
 */
var BUTTON_TOOLTIP_POSITION;
(function (BUTTON_TOOLTIP_POSITION) {
    /**
     * Positioned on the top.
     */
    BUTTON_TOOLTIP_POSITION["TOP"] = "top";
    /**
     * Positioned on the right.
     */
    BUTTON_TOOLTIP_POSITION["RIGHT"] = "right";
    /**
     * Positioned on the bottom.
     */
    BUTTON_TOOLTIP_POSITION["BOTTOM"] = "bottom";
    /**
     * Positined on the left.
     */
    BUTTON_TOOLTIP_POSITION["LEFT"] = "left";
})(BUTTON_TOOLTIP_POSITION || (BUTTON_TOOLTIP_POSITION = {}));

export { BUTTON_KIND, BUTTON_SIZE, BUTTON_TOOLTIP_ALIGNMENT, BUTTON_TOOLTIP_POSITION, BUTTON_TYPE };
//# sourceMappingURL=defs.js.map
