/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { classMap } from 'lit/directives/class-map.js';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import { CHAT_BUTTON_SIZE } from './defs.js';
export { CHAT_BUTTON_SIZE } from './defs.js';
import styles from './chat-button.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Chat button skeleton.
 *
 * @element cds-chat-button-skeleton
 */
let CDSChatButtonSkeleton = class CDSChatButtonSkeleton extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Specify the size of the `ChatButtonSkeleton`, from the following list of sizes: 'sm', 'md', 'lg'
         */
        this.size = CHAT_BUTTON_SIZE.LARGE;
    }
    render() {
        const skeletonClasses = classMap({
            [`${prefix}--skeleton`]: true,
            [`${prefix}--btn`]: true,
            [`${prefix}--chat-btn`]: true,
            [`${prefix}--layout--size-${this.size}`]: this.size,
        });
        return html ` <div class="${skeletonClasses}"></div> `;
    }
};
CDSChatButtonSkeleton.styles = styles;
__decorate([
    property({ reflect: true })
], CDSChatButtonSkeleton.prototype, "size", void 0);
CDSChatButtonSkeleton = __decorate([
    carbonElement(`${prefix}-chat-button-skeleton`)
], CDSChatButtonSkeleton);
var CDSChatButtonSkeleton$1 = CDSChatButtonSkeleton;

export { CDSChatButtonSkeleton$1 as default };
//# sourceMappingURL=chat-button-skeleton.js.map
