/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './checkbox.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of number input.
 */
let CDSCheckboxSkeleton = class CDSCheckboxSkeleton extends LitElement {
    render() {
        return html `
      <label class="${prefix}--checkbox-label" for="checkbox" part="label">
        <span class="${prefix}--checkbox-label-text ${prefix}--skeleton"
          ><slot></slot
        ></span>
      </label>
    `;
    }
};
CDSCheckboxSkeleton.styles = styles;
CDSCheckboxSkeleton = __decorate([
    carbonElement(`${prefix}-checkbox-skeleton`)
], CDSCheckboxSkeleton);
var CDSCheckboxSkeleton$1 = CDSCheckboxSkeleton;

export { CDSCheckboxSkeleton$1 as default };
//# sourceMappingURL=checkbox-skeleton.js.map
