/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import './code-snippet.js';
import styles from './code-snippet.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import { CODE_SNIPPET_TYPE } from './defs.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of code snippet.
 */
let CDSCodeSnippetSkeleton = class CDSCodeSnippetSkeleton extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * The type of code snippet. Corresponds to the attribute with the same name.
         */
        this.type = CODE_SNIPPET_TYPE.SINGLE;
    }
    render() {
        return html `
      <div class="${prefix}--snippet-container">
        ${this.type !== CODE_SNIPPET_TYPE.MULTI
            ? html ` <span></span> `
            : html ` <span></span><span></span><span></span> `}
      </div>
    `;
    }
};
CDSCodeSnippetSkeleton.styles = styles;
__decorate([
    property({ reflect: true })
], CDSCodeSnippetSkeleton.prototype, "type", void 0);
CDSCodeSnippetSkeleton = __decorate([
    carbonElement(`${prefix}-code-snippet-skeleton`)
], CDSCodeSnippetSkeleton);
var CDSCodeSnippetSkeleton$1 = CDSCodeSnippetSkeleton;

export { CDSCodeSnippetSkeleton$1 as default };
//# sourceMappingURL=code-snippet-skeleton.js.map
