/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { prefix } from '../../globals/settings.js';
import CDSDropdownItem from '../dropdown/dropdown-item.js';
import styles from './combo-box.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Combo box item.
 *
 * @element cds-combo-box-item
 */
let CDSComboBoxItem = class CDSComboBoxItem extends CDSDropdownItem {
};
CDSComboBoxItem.styles = styles;
CDSComboBoxItem = __decorate([
    carbonElement(`${prefix}-combo-box-item`)
], CDSComboBoxItem);
var CDSComboBoxItem$1 = CDSComboBoxItem;

export { CDSComboBoxItem$1 as default };
//# sourceMappingURL=combo-box-item.js.map
