/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from '../copy-button/copy-button.scss.js';
import CDSIconButton from '../icon-button/icon-button.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Copy.
 *
 * @element cds-copy
 */
let CDSCopy = class CDSCopy extends CDSIconButton {
    constructor() {
        super(...arguments);
        /**
         * `true` to show the feedback tooltip.
         */
        this._showFeedback = false;
        /**
         * `true` to show the feedback tooltip.
         */
        this._animation = '';
        this._createHandleFeedbackTooltip = () => {
            let timeoutId;
            return (timeout) => {
                var _a, _b;
                const buttonClasses = (_b = (_a = this.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('button')) === null || _b === void 0 ? void 0 : _b.classList;
                if (timeoutId) {
                    clearTimeout(timeoutId);
                    timeoutId = undefined;
                }
                this._showFeedback = true;
                buttonClasses === null || buttonClasses === void 0 ? void 0 : buttonClasses.add(`${prefix}--copy-btn--animating`);
                this._animation = 'fade-in';
                buttonClasses === null || buttonClasses === void 0 ? void 0 : buttonClasses.add(`${prefix}--copy-btn--${this._animation}`);
                this.requestUpdate();
                timeoutId = setTimeout(() => {
                    this._showFeedback = false;
                    this._animation = 'fade-out';
                    buttonClasses === null || buttonClasses === void 0 ? void 0 : buttonClasses.remove(`${prefix}--copy-btn--fade-in`);
                    buttonClasses === null || buttonClasses === void 0 ? void 0 : buttonClasses.add(`${prefix}--copy-btn--${this._animation}`);
                    this.requestUpdate();
                }, timeout);
            };
        };
        /**
         * Handles showing/hiding the feedback tooltip.
         */
        this._handleFeedbackTooltip = this._createHandleFeedbackTooltip();
        /**
         * Specify the string that is displayed when the button is clicked and the content is copi
         */
        this.feedback = 'Copied!';
        /**
         * The number in milliseconds to determine how long the tooltip should remain.
         */
        this.feedbackTimeout = 2000;
    }
    /**
     * Handles `click` event on the copy button.
     */
    _handleClickButton() {
        this._handleFeedbackTooltip(this.feedbackTimeout);
    }
    // eslint-disable-next-line class-methods-use-this
    _renderTooltipContent() {
        return html `
      <cds-tooltip-content>
        ${this._showFeedback
            ? this.feedback
            : html `<slot name="tooltip-content"></slot>`}
      </cds-tooltip-content>
    `;
    }
    connectedCallback() {
        this.closeOnActivation = false;
        this.align = 'bottom';
        this.addEventListener('click', this._handleClickButton);
        super.connectedCallback();
    }
    updated(changedProperties) {
        var _a, _b, _c, _d, _e;
        (_b = (_a = this.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('button')) === null || _b === void 0 ? void 0 : _b.addEventListener('animationend', () => {
            var _a, _b;
            if (this._animation === 'fade-out') {
                const buttonClasses = (_b = (_a = this.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('button')) === null || _b === void 0 ? void 0 : _b.classList;
                buttonClasses === null || buttonClasses === void 0 ? void 0 : buttonClasses.remove(`${prefix}--copy-btn--animating`);
                buttonClasses === null || buttonClasses === void 0 ? void 0 : buttonClasses.remove(`${prefix}--copy-btn--${this._animation}`);
                this._animation = '';
            }
        });
        super.updated(changedProperties);
        (_d = (_c = this.shadowRoot) === null || _c === void 0 ? void 0 : _c.querySelector('button') // @ts-ignore: TS thinks `host` doesn't exist on `parentNode`
        ) === null || _d === void 0 ? void 0 : _d.setAttribute('aria-label', (_e = this.parentNode) === null || _e === void 0 ? void 0 : _e.host.textContent);
    }
};
CDSCopy.styles = styles;
__decorate([
    property()
], CDSCopy.prototype, "feedback", void 0);
__decorate([
    property({ type: Number, attribute: 'feedback-timeout' })
], CDSCopy.prototype, "feedbackTimeout", void 0);
CDSCopy = __decorate([
    carbonElement(`${prefix}-copy`)
], CDSCopy);
var CDSCopy$1 = CDSCopy;

export { CDSCopy$1 as default };
//# sourceMappingURL=copy.js.map
