/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Table size.
 */
var TABLE_SIZE;
(function (TABLE_SIZE) {
    /**
     * xs size.
     */
    TABLE_SIZE["XS"] = "xs";
    /**
     * sm size.
     */
    TABLE_SIZE["SM"] = "sm";
    /**
     * md size.
     */
    TABLE_SIZE["MD"] = "md";
    /**
     * lg size - default.
     */
    TABLE_SIZE["LG"] = "lg";
    /**
     * xl size.
     */
    TABLE_SIZE["XL"] = "xl";
})(TABLE_SIZE || (TABLE_SIZE = {}));
/**
 * Table sort state.
 */
var TABLE_SORT_DIRECTION;
(function (TABLE_SORT_DIRECTION) {
    /**
     * Not sorted.
     */
    TABLE_SORT_DIRECTION["NONE"] = "none";
    /**
     * Sorted ascendingly.
     */
    TABLE_SORT_DIRECTION["ASCENDING"] = "ascending";
    /**
     * Sorted descendingly.
     */
    TABLE_SORT_DIRECTION["DESCENDING"] = "descending";
})(TABLE_SORT_DIRECTION || (TABLE_SORT_DIRECTION = {}));
/**
 * Table sort cycle.
 */
var TABLE_SORT_CYCLE;
(function (TABLE_SORT_CYCLE) {
    TABLE_SORT_CYCLE["BI_STATES_FROM_ASCENDING"] = "bi-states-from-ascending";
    TABLE_SORT_CYCLE["BI_STATES_FROM_DESCENDING"] = "bi-states-from-descending";
    TABLE_SORT_CYCLE["TRI_STATES_FROM_ASCENDING"] = "tri-states-from-ascending";
    TABLE_SORT_CYCLE["TRI_STATES_FROM_DESCENDING"] = "tri-states-from-descending";
})(TABLE_SORT_CYCLE || (TABLE_SORT_CYCLE = {}));
/**
 * Mapping of table sort cycles to table sort states.
 */
const TABLE_SORT_CYCLES = {
    [TABLE_SORT_CYCLE.BI_STATES_FROM_ASCENDING]: [
        TABLE_SORT_DIRECTION.ASCENDING,
        TABLE_SORT_DIRECTION.DESCENDING,
    ],
    [TABLE_SORT_CYCLE.BI_STATES_FROM_DESCENDING]: [
        TABLE_SORT_DIRECTION.DESCENDING,
        TABLE_SORT_DIRECTION.ASCENDING,
    ],
    [TABLE_SORT_CYCLE.TRI_STATES_FROM_ASCENDING]: [
        TABLE_SORT_DIRECTION.NONE,
        TABLE_SORT_DIRECTION.ASCENDING,
        TABLE_SORT_DIRECTION.DESCENDING,
    ],
    [TABLE_SORT_CYCLE.TRI_STATES_FROM_DESCENDING]: [
        TABLE_SORT_DIRECTION.NONE,
        TABLE_SORT_DIRECTION.DESCENDING,
        TABLE_SORT_DIRECTION.ASCENDING,
    ],
};

export { TABLE_SIZE, TABLE_SORT_CYCLE, TABLE_SORT_CYCLES, TABLE_SORT_DIRECTION };
//# sourceMappingURL=defs.js.map
