/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { query, property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './data-table.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Data table body.
 *
 * @element cds-table-body
 */
let CDSTableBody = class CDSTableBody extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Handles `slotchange` event in the `<slot>` element in the shadow DOM.
         */
        this._handleSlotChange = () => {
            this._updateZebra();
            this.dispatchEvent(new CustomEvent(this.constructor.eventTableBodyContentChange, { bubbles: true, cancelable: false }));
        };
        /**
         * TODO: Uncomment when Carbon fully implements sticky header
         * Specify whether the header should be sticky.
         * Still experimental: may not work with every combination of table props
         */
        // @property({ type: Boolean, reflect: true, attribute: 'sticky-header' })
        // stickyHeader = false;
        /**
         * The color scheme.
         */
        this.useZebraStyles = false;
    }
    /**
     * Updates `even`/`odd` properties of the child `<cds-table-row>`s.
     */
    _updateZebra() {
        const { useZebraStyles, _slotNode: slotNode } = this;
        slotNode.assignedNodes().forEach((node) => {
            if (node.nodeType === Node.ELEMENT_NODE) {
                const even = node.matches('*:nth-of-type(even)');
                node.even = useZebraStyles && even;
                node.odd = useZebraStyles && !even;
            }
        });
    }
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'rowgroup');
        }
        super.connectedCallback();
    }
    updated(changedProperties) {
        if (changedProperties.has('useZebraStyles')) {
            this._updateZebra();
        }
    }
    render() {
        const { _handleSlotChange: handleSlotChange } = this;
        return html ` <slot @slotchange="${handleSlotChange}"></slot> `;
    }
    /**
     * The name of the custom event fired after the body slot content changes
     */
    static get eventTableBodyContentChange() {
        return `${prefix}-table-body-content-change`;
    }
};
CDSTableBody.styles = styles;
__decorate([
    query('slot')
], CDSTableBody.prototype, "_slotNode", void 0);
__decorate([
    property({ type: Boolean, reflect: true, attribute: 'use-zebra-styles' })
], CDSTableBody.prototype, "useZebraStyles", void 0);
CDSTableBody = __decorate([
    carbonElement(`${prefix}-table-body`)
], CDSTableBody);
var CDSTableBody$1 = CDSTableBody;

export { CDSTableBody$1 as default };
//# sourceMappingURL=table-body.js.map
