/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './data-table.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Data table cell content.
 *
 * @element cds-table-cell-content
 */
let CDSTableCellContent = class CDSTableCellContent extends LitElement {
    render() {
        return html ` <slot></slot> `;
    }
};
CDSTableCellContent.styles = styles;
CDSTableCellContent = __decorate([
    carbonElement(`${prefix}-table-cell-content`)
], CDSTableCellContent);
var CDSTableCellContent$1 = CDSTableCellContent;

export { CDSTableCellContent$1 as default };
//# sourceMappingURL=table-cell-content.js.map
