/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './data-table.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Data table cell.
 *
 * @element cds-table-cell
 */
let CDSTableCell = class CDSTableCell extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Specify whether the overflow menu (if it exists) should be shown always, or only on hover
         */
        this.overflowMenuOnHover = false;
    }
    /**
     * TODO: Uncomment when Carbon fully implements sticky header
     * Specify whether the header should be sticky.
     * Still experimental: may not work with every combination of table props
     */
    // @property({ type: Boolean, reflect: true, attribute: 'sticky-header' })
    // stickyHeader = false;
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'cell');
        }
        super.connectedCallback();
    }
    render() {
        return html `<slot></slot>`;
    }
};
CDSTableCell.styles = styles;
__decorate([
    property({
        type: Boolean,
        reflect: true,
        attribute: 'overflow-menu-on-hover',
    })
], CDSTableCell.prototype, "overflowMenuOnHover", void 0);
__decorate([
    property({ reflect: true })
], CDSTableCell.prototype, "size", void 0);
CDSTableCell = __decorate([
    carbonElement(`${prefix}-table-cell`)
], CDSTableCell);
var CDSTableCell$1 = CDSTableCell;

export { CDSTableCell$1 as default };
//# sourceMappingURL=table-cell.js.map
