/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { html, LitElement } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './data-table.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import HostListener from '../../globals/decorators/host-listener.js';
import HostListenerMixin from '../../globals/mixins/host-listener.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Table row of collapsible details.
 *
 * @element cds-table-expanded-row
 */
let CDSTableExpandedRow = class CDSTableExpandedRow extends HostListenerMixin(LitElement) {
    constructor() {
        super(...arguments);
        /**
         * The colspan.
         */
        this.colSpan = 1;
        /**
         * `true` if the table row should be expanded.
         */
        this.expanded = false;
        /**
         * `true` if the table row should be filtered.
         */
        this.filtered = false;
        /**
         * `true` if the table row should be highlighted.
         */
        this.highlighted = false;
        /**
         * `true` if the previous table row has been selected
         */
        this.selected = false;
    }
    /**
     * Handles `mouseover`/`mouseout` event handler on this element.
     *
     * @param event The event.
     */
    _handleMouseOverOut(event) {
        const { selectorRow } = this.constructor;
        const { previousElementSibling } = this;
        if (previousElementSibling === null || previousElementSibling === void 0 ? void 0 : previousElementSibling.matches(selectorRow)) {
            previousElementSibling.highlighted =
                event.type === 'mouseover';
        }
    }
    render() {
        const { colSpan } = this;
        return html `
      <td colspan="${colSpan}">
        <div class="${prefix}--child-row-inner-container">
          <slot></slot>
        </div>
      </td>
    `;
    }
    updated() {
        var _a;
        ((_a = this.previousElementSibling) === null || _a === void 0 ? void 0 : _a.hasAttribute('ai-label'))
            ? this.setAttribute('ai-label', '')
            : this.removeAttribute('ai-label');
    }
    /**
     * A selector that will return the previous sibling row.
     */
    static get selectorRow() {
        return `${prefix}-table-row`;
    }
};
CDSTableExpandedRow.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    HostListener('mouseover'),
    HostListener('mouseout')
    // @ts-ignore: The decorator refers to this method but TS thinks this method is not referred to
], CDSTableExpandedRow.prototype, "_handleMouseOverOut", null);
__decorate([
    property({ type: Number, attribute: 'colspan' })
], CDSTableExpandedRow.prototype, "colSpan", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSTableExpandedRow.prototype, "expanded", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSTableExpandedRow.prototype, "filtered", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSTableExpandedRow.prototype, "highlighted", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSTableExpandedRow.prototype, "selected", void 0);
CDSTableExpandedRow = __decorate([
    carbonElement(`${prefix}-table-expanded-row`)
], CDSTableExpandedRow);
var CDSTableExpandedRow$1 = CDSTableExpandedRow;

export { CDSTableExpandedRow$1 as default };
//# sourceMappingURL=table-expanded-row.js.map
