/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './data-table.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Data table header.
 *
 * @element cds-table-head
 */
let CDSTableHead = class CDSTableHead extends LitElement {
    /**
     * TODO: Uncomment when Carbon fully implements sticky header
     * Specify whether the header should be sticky.
     * Still experimental: may not work with every combination of table props
     */
    //@property({ type: Boolean, reflect: true, attribute: 'sticky-header' })
    // stickyHeader = false;
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'rowgroup');
        }
        super.connectedCallback();
    }
    render() {
        return html ` <slot></slot> `;
    }
};
CDSTableHead.styles = styles;
CDSTableHead = __decorate([
    carbonElement(`${prefix}-table-head`)
], CDSTableHead);
var CDSTableHead$1 = CDSTableHead;

export { CDSTableHead$1 as default };
//# sourceMappingURL=table-head.js.map
