/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './data-table.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Data table header description
 *
 * @element cds-table-header-description
 */
let CDSTableHeaderDescription = class CDSTableHeaderDescription extends LitElement {
    render() {
        return html ` <slot></slot> `;
    }
};
CDSTableHeaderDescription.styles = styles;
CDSTableHeaderDescription = __decorate([
    carbonElement(`${prefix}-table-header-description`)
], CDSTableHeaderDescription);
var CDSTableHeaderDescription$1 = CDSTableHeaderDescription;

export { CDSTableHeaderDescription$1 as default };
//# sourceMappingURL=table-header-description.js.map
