/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { prefix } from '../../globals/settings.js';
import CDSTableRow from './table-row.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Data table header row.
 *
 * @element cds-table-header-row
 * @fires cds-table-change-selection-all
 *   The name of the custom event fired before this row is selected/unselected upon a user gesture.
 *   Cancellation of this event stops the user-initiated change in selection.
 */
let CDSTableHeaderRow = class CDSTableHeaderRow extends CDSTableRow {
    /**
     * The name of the custom event fired before this row is selected/unselected upon a user gesture.
     * Cancellation of this event stops the user-initiated change in selection.
     */
    static get eventBeforeChangeSelection() {
        return `${prefix}-table-change-selection-all`;
    }
};
CDSTableHeaderRow = __decorate([
    carbonElement(`${prefix}-table-header-row`)
], CDSTableHeaderRow);
var CDSTableHeaderRow$1 = CDSTableHeaderRow;

export { CDSTableHeaderRow$1 as default };
//# sourceMappingURL=table-header-row.js.map
