/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './data-table.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Data table header title
 *
 * @element cds-table-header-title
 */
let CDSTableHeader = class CDSTableHeader extends LitElement {
    render() {
        return html ` <slot></slot> `;
    }
};
CDSTableHeader.styles = styles;
CDSTableHeader = __decorate([
    carbonElement(`${prefix}-table-header-title`)
], CDSTableHeader);
var CDSTableHeader$1 = CDSTableHeader;

export { CDSTableHeader$1 as default };
//# sourceMappingURL=table-header-title.js.map
