/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './data-table.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Table toolbar content.
 *
 * @element cds-table-toolbar-content
 */
let CDSTableToolbarContent = class CDSTableToolbarContent extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * `true` if this batch actions bar is active.
         */
        this.hasBatchActions = false;
    }
    updated(changedProperties) {
        if (changedProperties.has('hasBatchActions')) {
            this.setAttribute('tabindex', `${this.hasBatchActions ? '-1' : ''}`);
        }
        if (changedProperties.has('size')) {
            [...this.children].forEach((e) => {
                const size = this.size === 'xs'
                    ? 'sm'
                    : this.size === 'md' || this.size === 'xl'
                        ? 'lg'
                        : this.size;
                e.setAttribute('size', size);
            });
        }
    }
    render() {
        return html ` <slot></slot> `;
    }
};
CDSTableToolbarContent.styles = styles;
__decorate([
    property({ type: Boolean, reflect: true, attribute: 'has-batch-actions' })
], CDSTableToolbarContent.prototype, "hasBatchActions", void 0);
__decorate([
    property({ reflect: true })
], CDSTableToolbarContent.prototype, "size", void 0);
CDSTableToolbarContent = __decorate([
    carbonElement(`${prefix}-table-toolbar-content`)
], CDSTableToolbarContent);
var CDSTableToolbarContent$1 = CDSTableToolbarContent;

export { CDSTableToolbarContent$1 as default };
//# sourceMappingURL=table-toolbar-content.js.map
