/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './data-table.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Table toolbar.
 *
 * @element cds-table-toolbar
 */
let CDSTableToolbar = class CDSTableToolbar extends LitElement {
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'section');
        }
        super.connectedCallback();
    }
    updated(changedProperties) {
        if (changedProperties.has('size')) {
            this.querySelector(this.constructor.selectorToolbarContent).size = this.size;
        }
    }
    render() {
        return html ` <slot></slot> `;
    }
    /**
     * The CSS selector to find the toolbar contents
     */
    static get selectorToolbarContent() {
        return `${prefix}-table-toolbar-content`;
    }
};
CDSTableToolbar.styles = styles;
__decorate([
    property({ reflect: true })
], CDSTableToolbar.prototype, "size", void 0);
CDSTableToolbar = __decorate([
    carbonElement(`${prefix}-table-toolbar`)
], CDSTableToolbar);
var CDSTableToolbar$1 = CDSTableToolbar;

export { CDSTableToolbar$1 as default };
//# sourceMappingURL=table-toolbar.js.map
