/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { LitElement } from 'lit';
import { DATE_PICKER_INPUT_KIND } from './date-picker-input';
/**
 * Skeleton version of the input box for date picker.
 */
declare class CDSDatePickerInputSkeleton extends LitElement {
    /**
     * Date picker input kind. Corresponds to the attribute with the same name.
     */
    kind: DATE_PICKER_INPUT_KIND;
    render(): import("lit-html").TemplateResult<1>;
    static styles: any;
}
export default CDSDatePickerInputSkeleton;
