/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import './date-picker-input.js';
import styles from './date-picker.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import { DATE_PICKER_INPUT_KIND } from './defs.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton version of the input box for date picker.
 */
let CDSDatePickerInputSkeleton = class CDSDatePickerInputSkeleton extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Date picker input kind. Corresponds to the attribute with the same name.
         */
        this.kind = DATE_PICKER_INPUT_KIND.SIMPLE;
    }
    render() {
        return html `
      <span class="${prefix}--label"></span>
      <div class="${prefix}--date-picker__input ${prefix}--skeleton"></div>
    `;
    }
};
CDSDatePickerInputSkeleton.styles = styles;
__decorate([
    property({ reflect: true })
], CDSDatePickerInputSkeleton.prototype, "kind", void 0);
CDSDatePickerInputSkeleton = __decorate([
    carbonElement(`${prefix}-date-picker-input-skeleton`)
], CDSDatePickerInputSkeleton);
var CDSDatePickerInputSkeleton$1 = CDSDatePickerInputSkeleton;

export { CDSDatePickerInputSkeleton$1 as default };
//# sourceMappingURL=date-picker-input-skeleton.js.map
