/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

export { FORM_ELEMENT_COLOR_SCHEME as DATE_PICKER_INPUT_COLOR_SCHEME } from '../../globals/shared-enums.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2022, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Date picker input kinds.
 */
var DATE_PICKER_INPUT_KIND;
(function (DATE_PICKER_INPUT_KIND) {
    /**
     * One for simple variant of date picker, comes without the calendar dropdown.
     */
    DATE_PICKER_INPUT_KIND["SIMPLE"] = "simple";
    /**
     * One for single variant of date picker.
     */
    DATE_PICKER_INPUT_KIND["SINGLE"] = "single";
    /**
     * One for the start date for the range variant.
     */
    DATE_PICKER_INPUT_KIND["FROM"] = "from";
    /**
     * One for the end date for the range variant.
     */
    DATE_PICKER_INPUT_KIND["TO"] = "to";
})(DATE_PICKER_INPUT_KIND || (DATE_PICKER_INPUT_KIND = {}));

export { DATE_PICKER_INPUT_KIND };
//# sourceMappingURL=defs.js.map
