/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

export { FORM_ELEMENT_COLOR_SCHEME as DROPDOWN_COLOR_SCHEME } from '../../globals/shared-enums.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2022, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Navigation direction, associated with key symbols.
 */
const NAVIGATION_DIRECTION = {
    Up: -1,
    ArrowUp: -1,
    Down: 1,
    ArrowDown: 1,
};
/**
 * The keyboard action categories for dropdown.
 */
var DROPDOWN_KEYBOARD_ACTION;
(function (DROPDOWN_KEYBOARD_ACTION) {
    /**
     * Not doing any action.
     */
    DROPDOWN_KEYBOARD_ACTION["NONE"] = "none";
    /**
     * Keyboard action to close menu.
     */
    DROPDOWN_KEYBOARD_ACTION["CLOSING"] = "closing";
    /**
     * Keyboard action to navigate back/forward.
     */
    DROPDOWN_KEYBOARD_ACTION["NAVIGATING"] = "navigating";
    /**
     * Keyboard action to open/close menu on the trigger button or select/deselect a menu item.
     */
    DROPDOWN_KEYBOARD_ACTION["TRIGGERING"] = "triggering";
})(DROPDOWN_KEYBOARD_ACTION || (DROPDOWN_KEYBOARD_ACTION = {}));
/**
 * Dropdown size.
 */
var DROPDOWN_SIZE;
(function (DROPDOWN_SIZE) {
    /**
     * Small size.
     */
    DROPDOWN_SIZE["SMALL"] = "sm";
    /**
     * Medium size.
     */
    DROPDOWN_SIZE["MEDIUM"] = "md";
    /**
     * Large size.
     */
    DROPDOWN_SIZE["LARGE"] = "lg";
})(DROPDOWN_SIZE || (DROPDOWN_SIZE = {}));
/**
 * Dropdown types.
 */
var DROPDOWN_TYPE;
(function (DROPDOWN_TYPE) {
    /**
     * Default type.
     */
    DROPDOWN_TYPE["DEFAULT"] = "";
    /**
     * Inline type.
     */
    DROPDOWN_TYPE["INLINE"] = "inline";
})(DROPDOWN_TYPE || (DROPDOWN_TYPE = {}));
/**
 * Dropdown direction.
 */
var DROPDOWN_DIRECTION;
(function (DROPDOWN_DIRECTION) {
    /**
     * Top.
     */
    DROPDOWN_DIRECTION["TOP"] = "top";
    /**
     * Bottom.
     */
    DROPDOWN_DIRECTION["BOTTOM"] = "bottom";
})(DROPDOWN_DIRECTION || (DROPDOWN_DIRECTION = {}));

export { DROPDOWN_DIRECTION, DROPDOWN_KEYBOARD_ACTION, DROPDOWN_SIZE, DROPDOWN_TYPE, NAVIGATION_DIRECTION };
//# sourceMappingURL=defs.js.map
