/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './dropdown.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton version of dropdown.
 */
let CDSDropdownSkeleton = class CDSDropdownSkeleton extends LitElement {
    render() {
        return html `
      <div
        class="${prefix}--skeleton ${prefix}--dropdown-v2 ${prefix}--list-box ${prefix}--form-item">
        <div class="${prefix}--list-box__field">
          <span class="${prefix}--list-box__label"></span>
        </div>
      </div>
    `;
    }
};
CDSDropdownSkeleton.styles = styles;
CDSDropdownSkeleton = __decorate([
    carbonElement(`${prefix}-dropdown-skeleton`)
], CDSDropdownSkeleton);
var CDSDropdownSkeleton$1 = CDSDropdownSkeleton;

export { CDSDropdownSkeleton$1 as default };
//# sourceMappingURL=dropdown-skeleton.js.map
